/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CreateAccount;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class AccountsCollection
implements RestCollection<TopLevelResource, AccountResource>,
AcceptsCreate<TopLevelResource> {
    private final Provider<CurrentUser> self;
    private final AccountResolver resolver;
    private final AccountControl.Factory accountControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final DynamicMap<RestView<AccountResource>> views;
    private final CreateAccount.Factory createAccountFactory;

    @Inject
    AccountsCollection(Provider<CurrentUser> self, AccountResolver resolver, AccountControl.Factory accountControlFactory, IdentifiedUser.GenericFactory userFactory, DynamicMap<RestView<AccountResource>> views, CreateAccount.Factory createAccountFactory) {
        this.self = self;
        this.resolver = resolver;
        this.accountControlFactory = accountControlFactory;
        this.userFactory = userFactory;
        this.views = views;
        this.createAccountFactory = createAccountFactory;
    }

    @Override
    public AccountResource parse(TopLevelResource root, IdString id) throws ResourceNotFoundException, AuthException, OrmException {
        IdentifiedUser user = this.parseId(id.get());
        if (user == null) {
            throw new ResourceNotFoundException(id);
        }
        if (!this.accountControlFactory.get().canSee(user.getAccount())) {
            throw new ResourceNotFoundException(id);
        }
        return new AccountResource(user);
    }

    public IdentifiedUser parse(String id) throws AuthException, UnprocessableEntityException, OrmException {
        IdentifiedUser user = this.parseId(id);
        if (user == null) {
            throw new UnprocessableEntityException(String.format("Account Not Found: %s", id));
        }
        if (!this.accountControlFactory.get().canSee(user.getAccount())) {
            throw new UnprocessableEntityException(String.format("Account Not Found: %s", id));
        }
        return user;
    }

    public IdentifiedUser parseId(String id) throws AuthException, OrmException {
        if (id.equals("self")) {
            CurrentUser user = this.self.get();
            if (user.isIdentifiedUser()) {
                return (IdentifiedUser)user;
            }
            if (user instanceof AnonymousUser) {
                throw new AuthException("Authentication required");
            }
            return null;
        }
        Account match = this.resolver.find(id);
        if (match == null) {
            return null;
        }
        return this.userFactory.create(match.getId());
    }

    @Override
    public RestView<TopLevelResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public DynamicMap<RestView<AccountResource>> views() {
        return this.views;
    }

    public CreateAccount create(TopLevelResource parent, IdString username) {
        return this.createAccountFactory.create(username.get());
    }
}

