/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CapabilityControl {
    private final CapabilityCollection capabilities;
    private final CurrentUser user;
    private final Map<String, List<PermissionRule>> effective;
    private Boolean canAdministrateServer;
    private Boolean canEmailReviewers;
    private static final Predicate<PermissionRule> ALLOWED_RULE = new Predicate<PermissionRule>(){

        @Override
        public boolean apply(PermissionRule rule) {
            return rule.getAction() == PermissionRule.Action.ALLOW;
        }
    };

    @Inject
    CapabilityControl(ProjectCache projectCache, @Assisted CurrentUser currentUser) {
        this.capabilities = projectCache.getAllProjects().getCapabilityCollection();
        this.user = currentUser;
        this.effective = new HashMap<String, List<PermissionRule>>();
    }

    public CurrentUser getCurrentUser() {
        return this.user;
    }

    public boolean canAdministrateServer() {
        if (this.canAdministrateServer == null) {
            this.canAdministrateServer = this.user.getRealUser() != this.user ? Boolean.valueOf(false) : Boolean.valueOf(this.user instanceof PeerDaemonUser || this.matchAny(this.capabilities.administrateServer, ALLOWED_RULE));
        }
        return this.canAdministrateServer;
    }

    public boolean canCreateAccount() {
        return this.canPerform("createAccount") || this.canAdministrateServer();
    }

    public boolean canCreateGroup() {
        return this.canPerform("createGroup") || this.canAdministrateServer();
    }

    public boolean canCreateProject() {
        return this.canPerform("createProject") || this.canAdministrateServer();
    }

    public boolean canEmailReviewers() {
        if (this.canEmailReviewers == null) {
            this.canEmailReviewers = this.matchAny(this.capabilities.emailReviewers, ALLOWED_RULE) || !this.matchAny(this.capabilities.emailReviewers, Predicates.not(ALLOWED_RULE));
        }
        return this.canEmailReviewers;
    }

    public boolean canKillTask() {
        return this.canPerform("killTask") || this.canAdministrateServer();
    }

    public boolean canViewAllAccounts() {
        return this.canPerform("viewAllAccounts") || this.canAdministrateServer();
    }

    public boolean canViewCaches() {
        return this.canPerform("viewCaches") || this.canAdministrateServer();
    }

    public boolean canFlushCaches() {
        return this.canPerform("flushCaches") || this.canAdministrateServer();
    }

    public boolean canViewConnections() {
        return this.canPerform("viewConnections") || this.canAdministrateServer();
    }

    public boolean canViewQueue() {
        return this.canPerform("viewQueue") || this.canAdministrateServer();
    }

    public boolean canAccessDatabase() {
        return this.canPerform("accessDatabase");
    }

    public boolean canStreamEvents() {
        return this.canPerform("streamEvents") || this.canAdministrateServer();
    }

    public boolean canRunGC() {
        return this.canPerform("runGC") || this.canAdministrateServer();
    }

    public boolean canGenerateHttpPassword() {
        return this.canPerform("generateHttpPassword") || this.canAdministrateServer();
    }

    public boolean canRunAs() {
        return this.canPerform("runAs");
    }

    public QueueProvider.QueueType getQueueType() {
        GroupMembership groups = this.user.getEffectiveGroups();
        boolean batch = false;
        for (PermissionRule r : this.capabilities.priority) {
            if (!CapabilityControl.match(groups, r)) continue;
            switch (r.getAction()) {
                case INTERACTIVE: {
                    if (SystemGroupBackend.isAnonymousOrRegistered(r.getGroup())) break;
                    return QueueProvider.QueueType.INTERACTIVE;
                }
                case BATCH: {
                    batch = true;
                    break;
                }
            }
        }
        if (batch) {
            return QueueProvider.QueueType.BATCH;
        }
        return QueueProvider.QueueType.INTERACTIVE;
    }

    public boolean canPerform(String permissionName) {
        if ("administrateServer".equals(permissionName)) {
            return this.canAdministrateServer();
        }
        return !this.access(permissionName).isEmpty();
    }

    public PermissionRange getRange(String permission) {
        if (GlobalCapability.hasRange(permission)) {
            return CapabilityControl.toRange(permission, this.access(permission));
        }
        return null;
    }

    private static PermissionRange toRange(String permissionName, List<PermissionRule> ruleList) {
        int min = 0;
        int max = 0;
        if (ruleList.isEmpty()) {
            PermissionRange.WithDefaults defaultRange = GlobalCapability.getRange(permissionName);
            if (defaultRange != null) {
                min = defaultRange.getDefaultMin();
                max = defaultRange.getDefaultMax();
            }
        } else {
            for (PermissionRule rule : ruleList) {
                min = Math.min(min, rule.getMin());
                max = Math.max(max, rule.getMax());
            }
        }
        return new PermissionRange(permissionName, min, max);
    }

    private List<PermissionRule> access(String permissionName) {
        List<PermissionRule> rules = this.effective.get(permissionName);
        if (rules != null) {
            return rules;
        }
        rules = this.capabilities.getPermission(permissionName);
        if (rules.isEmpty()) {
            this.effective.put(permissionName, rules);
            return rules;
        }
        GroupMembership groups = this.user.getEffectiveGroups();
        if (rules.size() == 1) {
            if (!CapabilityControl.match(groups, rules.get(0))) {
                rules = Collections.emptyList();
            }
            this.effective.put(permissionName, rules);
            return rules;
        }
        List<Object> mine = new ArrayList(rules.size());
        for (PermissionRule rule : rules) {
            if (!CapabilityControl.match(groups, rule)) continue;
            mine.add(rule);
        }
        if (mine.isEmpty()) {
            mine = Collections.emptyList();
        }
        this.effective.put(permissionName, mine);
        return mine;
    }

    private boolean matchAny(Iterable<PermissionRule> rules, Predicate<PermissionRule> predicate) {
        Iterable<AccountGroup.UUID> ids = Iterables.transform(Iterables.filter(rules, predicate), new Function<PermissionRule, AccountGroup.UUID>(){

            @Override
            public AccountGroup.UUID apply(PermissionRule rule) {
                return rule.getGroup().getUUID();
            }
        });
        return this.user.getEffectiveGroups().containsAnyOf(ids);
    }

    private static boolean match(GroupMembership groups, PermissionRule rule) {
        return groups.contains(rule.getGroup().getUUID());
    }

    public static interface Factory {
        public CapabilityControl create(CurrentUser var1);
    }
}

