/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.extensions.config.CapabilityDefinition;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OptionUtil;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kohsuke.args4j.Option;

class GetCapabilities
implements RestReadView<AccountResource> {
    @Deprecated
    @Option(name="--format", usage="(deprecated) output format")
    private OutputFormat format;
    private Set<String> query;
    private final Provider<CurrentUser> self;
    private final DynamicMap<CapabilityDefinition> pluginCapabilities;

    @Option(name="-q", metaVar="CAP", usage="Capability to inspect")
    void addQuery(String name) {
        if (this.query == null) {
            this.query = Sets.newHashSet();
        }
        Iterables.addAll(this.query, OptionUtil.splitOptionValue(name));
    }

    @Inject
    GetCapabilities(Provider<CurrentUser> self, DynamicMap<CapabilityDefinition> pluginCapabilities) {
        this.self = self;
        this.pluginCapabilities = pluginCapabilities;
    }

    @Override
    public Object apply(AccountResource resource) throws AuthException {
        if (this.self.get() != resource.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        CapabilityControl cc = resource.getUser().getCapabilities();
        LinkedHashMap<String, Object> have = Maps.newLinkedHashMap();
        for (String name : GlobalCapability.getAllNames()) {
            if (name.equals("priority") || !this.want(name) || !cc.canPerform(name)) continue;
            if (GlobalCapability.hasRange(name)) {
                have.put(name, new Range(cc.getRange(name)));
                continue;
            }
            have.put(name, true);
        }
        for (String pluginName : this.pluginCapabilities.plugins()) {
            for (String capability : this.pluginCapabilities.byPlugin(pluginName).keySet()) {
                String name = String.format("%s-%s", pluginName, capability);
                if (!this.want(name) || !cc.canPerform(name)) continue;
                have.put(name, true);
            }
        }
        have.put("accessDatabase", cc.canAccessDatabase());
        have.put("createAccount", cc.canCreateAccount());
        have.put("createGroup", cc.canCreateGroup());
        have.put("createProject", cc.canCreateProject());
        have.put("emailReviewers", cc.canEmailReviewers());
        have.put("flushCaches", cc.canFlushCaches());
        have.put("killTask", cc.canKillTask());
        have.put("runGC", cc.canRunGC());
        have.put("streamEvents", cc.canStreamEvents());
        have.put("viewAllAccounts", cc.canViewAllAccounts());
        have.put("viewCaches", cc.canViewCaches());
        have.put("viewConnections", cc.canViewConnections());
        have.put("viewQueue", cc.canViewQueue());
        QueueProvider.QueueType queue = cc.getQueueType();
        if (queue != QueueProvider.QueueType.INTERACTIVE || this.query != null && this.query.contains("priority")) {
            have.put("priority", (Object)queue);
        }
        Iterator itr = have.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (!this.want((String)e.getKey())) {
                itr.remove();
                continue;
            }
            if (!(e.getValue() instanceof Boolean) || ((Boolean)e.getValue()).booleanValue()) continue;
            itr.remove();
        }
        if (this.format == OutputFormat.TEXT) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : have.entrySet()) {
                sb.append((String)e.getKey());
                if (!(e.getValue() instanceof Boolean)) {
                    sb.append(": ");
                    sb.append(e.getValue().toString());
                }
                sb.append('\n');
            }
            return BinaryResult.create(sb.toString());
        }
        return OutputFormat.JSON.newGson().toJsonTree(have, new TypeToken<Map<String, Object>>(){}.getType());
    }

    private boolean want(String name) {
        return this.query == null || this.query.contains(name.toLowerCase());
    }

    static class CheckOne
    implements RestReadView<AccountResource.Capability> {
        CheckOne() {
        }

        public BinaryResult apply(AccountResource.Capability resource) {
            return BinaryResult.create("ok\n");
        }
    }

    private static class Range {
        private transient PermissionRange range;
        private int min;
        private int max;

        Range(PermissionRange r) {
            this.range = r;
            this.min = r.getMin();
            this.max = r.getMax();
        }

        public String toString() {
            return this.range.toString();
        }
    }
}

