/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.gwtorm.server.OrmException;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;

@Singleton
public class InternalAccountDirectory
extends AccountDirectory {
    private final Provider<ReviewDb> db;
    private final AccountCache accountCache;
    private final DynamicItem<AvatarProvider> avatar;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    InternalAccountDirectory(Provider<ReviewDb> db, AccountCache accountCache, DynamicItem<AvatarProvider> avatar, IdentifiedUser.GenericFactory userFactory) {
        this.db = db;
        this.accountCache = accountCache;
        this.avatar = avatar;
        this.userFactory = userFactory;
    }

    @Override
    public void fillAccountInfo(Iterable<? extends AccountInfo> in, Set<AccountDirectory.FillOptions> options) throws AccountDirectory.DirectoryException {
        ArrayListMultimap<Account.Id, AccountInfo> missing = ArrayListMultimap.create();
        for (AccountInfo accountInfo : in) {
            AccountState state = this.accountCache.getIfPresent(accountInfo._id);
            if (state != null) {
                this.fill(accountInfo, state.getAccount(), options);
                continue;
            }
            missing.put(accountInfo._id, accountInfo);
        }
        if (!missing.isEmpty()) {
            try {
                for (Account account : this.db.get().accounts().get(missing.keySet())) {
                    for (AccountInfo info : missing.get(account.getId())) {
                        this.fill(info, account, options);
                    }
                }
            }
            catch (OrmException e) {
                throw new AccountDirectory.DirectoryException(e);
            }
        }
    }

    private void fill(AccountInfo info, Account account, Set<AccountDirectory.FillOptions> options) {
        if (options.contains((Object)AccountDirectory.FillOptions.NAME)) {
            info.name = Strings.emptyToNull(account.getFullName());
            if (info.name == null) {
                info.name = account.getUserName();
            }
        }
        if (options.contains((Object)AccountDirectory.FillOptions.EMAIL)) {
            info.email = account.getPreferredEmail();
        }
        if (options.contains((Object)AccountDirectory.FillOptions.USERNAME)) {
            info.username = account.getUserName();
        }
        if (options.contains((Object)AccountDirectory.FillOptions.AVATARS)) {
            String u;
            info.avatars = Lists.newArrayListWithCapacity(1);
            AvatarProvider ap = this.avatar.get();
            if (ap != null && (u = ap.getUrl(this.userFactory.create(account.getId()), 26)) != null) {
                AccountInfo.AvatarInfo a = new AccountInfo.AvatarInfo();
                a.url = u;
                a.height = 26;
                info.avatars.add(a);
            }
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(AccountDirectory.class).to(InternalAccountDirectory.class);
        }
    }
}

