/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;

public class PutPreferred
implements RestModifyView<AccountResource.Email, Input> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache byIdCache;

    @Inject
    PutPreferred(Provider<CurrentUser> self, Provider<ReviewDb> dbProvider, AccountCache byIdCache) {
        this.self = self;
        this.dbProvider = dbProvider;
        this.byIdCache = byIdCache;
    }

    public Response<String> apply(AccountResource.Email rsrc, Input input) throws AuthException, ResourceNotFoundException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to set preferred email address");
        }
        return this.apply(rsrc.getUser(), rsrc.getEmail());
    }

    public Response<String> apply(IdentifiedUser user, String email) throws ResourceNotFoundException, OrmException {
        Account a = this.dbProvider.get().accounts().get(user.getAccountId());
        if (a == null) {
            throw new ResourceNotFoundException("account not found");
        }
        if (email.equals(a.getPreferredEmail())) {
            return Response.ok("");
        }
        a.setPreferredEmail(email);
        this.dbProvider.get().accounts().update(Collections.singleton(a));
        this.byIdCache.evict(a.getId());
        return Response.created("");
    }

    static class Input {
        Input() {
        }
    }
}

