/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.change.CherryPick;
import com.google.gerrit.server.change.DeleteDraftPatchSet;
import com.google.gerrit.server.change.PostReview;
import com.google.gerrit.server.change.Publish;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;

class RevisionApiImpl
implements RevisionApi {
    private final Changes changes;
    private final Provider<CherryPick> cherryPick;
    private final Provider<DeleteDraftPatchSet> deleteDraft;
    private final Provider<Rebase> rebase;
    private final Provider<PostReview> review;
    private final Provider<Submit> submit;
    private final Provider<Publish> publish;
    private final RevisionResource revision;

    @Inject
    RevisionApiImpl(Changes changes, Provider<CherryPick> cherryPick, Provider<DeleteDraftPatchSet> deleteDraft, Provider<Rebase> rebase, Provider<PostReview> review, Provider<Submit> submit, Provider<Publish> publish, @Assisted RevisionResource r) {
        this.changes = changes;
        this.cherryPick = cherryPick;
        this.deleteDraft = deleteDraft;
        this.rebase = rebase;
        this.review = review;
        this.submit = submit;
        this.publish = publish;
        this.revision = r;
    }

    @Override
    public void review(ReviewInput in) throws RestApiException {
        try {
            this.review.get().apply(this.revision, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot post review", e);
        }
    }

    @Override
    public void submit() throws RestApiException {
        SubmitInput in = new SubmitInput();
        in.waitForMerge = true;
        this.submit(in);
    }

    @Override
    public void submit(SubmitInput in) throws RestApiException {
        try {
            this.submit.get().apply(this.revision, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot submit change", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        try {
            this.publish.get().apply(this.revision, new Publish.Input());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot publish draft patch set", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteDraft.get().apply(this.revision, null);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete draft ps", e);
        }
    }

    @Override
    public ChangeApi rebase() throws RestApiException {
        try {
            return this.changes.id(this.rebase.get().apply((RevisionResource)this.revision, null)._number);
        }
        catch (EmailException | OrmException e) {
            throw new RestApiException("Cannot rebase ps", e);
        }
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput in) throws RestApiException {
        try {
            return this.changes.id(this.cherryPick.get().apply((RevisionResource)this.revision, (CherryPickInput)in)._number);
        }
        catch (EmailException | OrmException | IOException e) {
            throw new RestApiException("Cannot cherry pick", e);
        }
    }

    static interface Factory {
        public RevisionApiImpl create(RevisionResource var1);
    }
}

