/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.changes.Side;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.server.account.AccountInfo;
import java.sql.Timestamp;

public class CommentInfo {
    final String kind = "gerritcodereview#comment";
    String id;
    String path;
    Side side;
    Integer line;
    String inReplyTo;
    String message;
    Timestamp updated;
    AccountInfo author;
    CommentRange range;

    CommentInfo(PatchLineComment c, AccountInfo.Loader accountLoader) {
        this.id = Url.encode(c.getKey().get());
        this.path = c.getKey().getParentKey().getFileName();
        if (c.getSide() == 0) {
            this.side = Side.PARENT;
        }
        if (c.getLine() > 0) {
            this.line = c.getLine();
        }
        this.inReplyTo = Url.encode(c.getParentUuid());
        this.message = Strings.emptyToNull(c.getMessage());
        this.updated = c.getWrittenOn();
        this.range = c.getRange();
        if (accountLoader != null) {
            this.author = accountLoader.get(c.getAuthor());
        }
    }
}

