/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.MergeabilityCheckQueue;
import com.google.gerrit.server.change.MergeabilityChecksExecutor;
import com.google.gerrit.server.change.Mergeable;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeabilityChecker
implements GitReferenceUpdatedListener {
    private static final Logger log = LoggerFactory.getLogger(MergeabilityChecker.class);
    private final ThreadLocalRequestContext tl;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final Provider<Mergeable> mergeable;
    private final ChangeIndexer indexer;
    private final ListeningExecutorService executor;
    private final MergeabilityCheckQueue mergeabilityCheckQueue;
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private static final Function<Exception, IOException> MAPPER = new Function<Exception, IOException>(){

        @Override
        public IOException apply(Exception in) {
            if (in instanceof IOException) {
                return (IOException)in;
            }
            if (in instanceof ExecutionException && in.getCause() instanceof IOException) {
                return (IOException)in.getCause();
            }
            return new IOException(in);
        }
    };

    @Inject
    public MergeabilityChecker(ThreadLocalRequestContext tl, SchemaFactory<ReviewDb> schemaFactory, IdentifiedUser.GenericFactory identifiedUserFactory, ChangeControl.GenericFactory changeControlFactory, Provider<Mergeable> mergeable, ChangeIndexer indexer, @MergeabilityChecksExecutor WorkQueue.Executor executor, MergeabilityCheckQueue mergeabilityCheckQueue, MetaDataUpdate.Server metaDataUpdateFactory) {
        this.tl = tl;
        this.schemaFactory = schemaFactory;
        this.identifiedUserFactory = identifiedUserFactory;
        this.changeControlFactory = changeControlFactory;
        this.mergeable = mergeable;
        this.indexer = indexer;
        this.executor = MoreExecutors.listeningDecorator(executor);
        this.mergeabilityCheckQueue = mergeabilityCheckQueue;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
    }

    @Override
    public void onGitReferenceUpdated(GitReferenceUpdatedListener.Event event) {
        block6: {
            String ref = event.getRefName();
            if (ref.startsWith("refs/heads/") || ref.equals("refs/meta/config")) {
                this.executor.submit(new BranchUpdateTask(this.schemaFactory, new Project.NameKey(event.getProjectName()), ref));
            }
            if (ref.equals("refs/meta/config")) {
                Project.NameKey p = new Project.NameKey(event.getProjectName());
                try {
                    ProjectConfig oldCfg = this.parseConfig(p, event.getOldObjectId());
                    ProjectConfig newCfg = this.parseConfig(p, event.getNewObjectId());
                    if (!this.recheckMerges(oldCfg, newCfg)) break block6;
                    try {
                        new ProjectUpdateTask(this.schemaFactory, p, true).call();
                    }
                    catch (Exception e) {
                        String msg = "Failed to update mergeability flags for project " + p.get() + " on update of " + "refs/meta/config";
                        log.error(msg, e);
                        Throwables.propagateIfPossible(e);
                        throw new RuntimeException(msg, e);
                    }
                }
                catch (IOException | ConfigInvalidException e) {
                    String msg = "Failed to update mergeability flags for project " + p.get() + " on update of " + "refs/meta/config";
                    log.error(msg, e);
                    throw new RuntimeException(msg, e);
                }
            }
        }
    }

    private boolean recheckMerges(ProjectConfig oldCfg, ProjectConfig newCfg) {
        if (oldCfg == null || newCfg == null) {
            return true;
        }
        return !oldCfg.getProject().getSubmitType().equals((Object)newCfg.getProject().getSubmitType()) || oldCfg.getProject().getUseContentMerge() != newCfg.getProject().getUseContentMerge() || (oldCfg.getRulesId() == null ? newCfg.getRulesId() != null : !oldCfg.getRulesId().equals(newCfg.getRulesId()));
    }

    private ProjectConfig parseConfig(Project.NameKey p, String idStr) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        ObjectId id = ObjectId.fromString(idStr);
        if (ObjectId.zeroId().equals(id)) {
            return null;
        }
        return ProjectConfig.read(this.metaDataUpdateFactory.create(p), id);
    }

    public CheckedFuture<Boolean, IOException> updateAsync(Change change) {
        return this.updateAsync(change, false);
    }

    private CheckedFuture<Boolean, IOException> updateAsync(Change change, boolean force) {
        return Futures.makeChecked(this.executor.submit(new ChangeUpdateTask(this.schemaFactory, change, force)), MAPPER);
    }

    public CheckedFuture<?, IOException> updateAndIndexAsync(Change change) {
        final Change.Id id = change.getId();
        return Futures.makeChecked(Futures.transform(this.updateAsync(change), new AsyncFunction<Boolean, Object>(){

            @Override
            public ListenableFuture<Object> apply(Boolean indexUpdated) throws Exception {
                if (!indexUpdated.booleanValue()) {
                    return MergeabilityChecker.this.indexer.indexAsync(id);
                }
                return Futures.immediateFuture(null);
            }
        }), MAPPER);
    }

    public boolean update(Change change) throws IOException {
        try {
            return new ChangeUpdateTask(this.schemaFactory, change).call();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw MAPPER.apply(e);
        }
    }

    public void update(Project.NameKey project) throws IOException {
        try {
            Iterator i$ = new ProjectUpdateTask(this.schemaFactory, project, false).call().iterator();
            while (i$.hasNext()) {
                CheckedFuture f = (CheckedFuture)i$.next();
                f.checkedGet();
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw MAPPER.apply(e);
        }
    }

    private class ProjectUpdateTask
    extends UpdateTask {
        private final Project.NameKey project;

        ProjectUpdateTask(SchemaFactory<ReviewDb> schemaFactory, Project.NameKey project, boolean force) {
            super(schemaFactory, force);
            this.project = project;
        }

        @Override
        protected List<Change> loadChanges(ReviewDb db) throws OrmException {
            return db.changes().byProjectOpenAll(this.project).toList();
        }
    }

    private class BranchUpdateTask
    extends UpdateTask {
        private final Branch.NameKey branch;

        BranchUpdateTask(SchemaFactory<ReviewDb> schemaFactory, Project.NameKey project, String ref) {
            super(schemaFactory, false);
            this.branch = new Branch.NameKey(project, ref);
        }

        @Override
        protected List<Change> loadChanges(ReviewDb db) throws OrmException {
            return db.changes().byBranchOpenAll(this.branch).toList();
        }
    }

    private abstract class UpdateTask
    implements Callable<List<CheckedFuture<Boolean, IOException>>> {
        private final SchemaFactory<ReviewDb> schemaFactory;
        private final boolean force;

        UpdateTask(SchemaFactory<ReviewDb> schemaFactory, boolean force) {
            this.schemaFactory = schemaFactory;
            this.force = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CheckedFuture<Boolean, IOException>> call() throws Exception {
            List<Change> openChanges;
            try (ReviewDb db = this.schemaFactory.open();){
                openChanges = this.loadChanges(db);
            }
            ArrayList<CheckedFuture<Boolean, IOException>> futures = new ArrayList<CheckedFuture<Boolean, IOException>>(openChanges.size());
            for (Change change : MergeabilityChecker.this.mergeabilityCheckQueue.addAll(openChanges, this.force)) {
                futures.add(MergeabilityChecker.this.updateAsync(change, this.force));
            }
            return futures;
        }

        protected abstract List<Change> loadChanges(ReviewDb var1) throws OrmException;
    }

    private class ChangeUpdateTask
    implements Callable<Boolean> {
        private final SchemaFactory<ReviewDb> schemaFactory;
        private final Change change;
        private final boolean force;
        private ReviewDb reviewDb;

        ChangeUpdateTask(SchemaFactory<ReviewDb> schemaFactory, Change change) {
            this(schemaFactory, change, false);
        }

        ChangeUpdateTask(SchemaFactory<ReviewDb> schemaFactory, Change change, boolean force) {
            this.schemaFactory = schemaFactory;
            this.change = change;
            this.force = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            MergeabilityChecker.this.mergeabilityCheckQueue.updatingMergeabilityFlag(this.change, this.force);
            RequestContext context = new RequestContext(){

                @Override
                public CurrentUser getCurrentUser() {
                    return MergeabilityChecker.this.identifiedUserFactory.create(ChangeUpdateTask.this.change.getOwner());
                }

                @Override
                public Provider<ReviewDb> getReviewDbProvider() {
                    return new Provider<ReviewDb>(){

                        @Override
                        public ReviewDb get() {
                            if (ChangeUpdateTask.this.reviewDb == null) {
                                try {
                                    ChangeUpdateTask.this.reviewDb = (ReviewDb)ChangeUpdateTask.this.schemaFactory.open();
                                }
                                catch (OrmException e) {
                                    throw new ProvisionException("Cannot open ReviewDb", e);
                                }
                            }
                            return ChangeUpdateTask.this.reviewDb;
                        }
                    };
                }
            };
            RequestContext old = MergeabilityChecker.this.tl.setContext(context);
            ReviewDb db = context.getReviewDbProvider().get();
            try {
                PatchSet ps = db.patchSets().get(this.change.currentPatchSetId());
                Mergeable m = (Mergeable)MergeabilityChecker.this.mergeable.get();
                m.setForce(this.force);
                ChangeControl control = MergeabilityChecker.this.changeControlFactory.controlFor(this.change.getId(), context.getCurrentUser());
                Mergeable.MergeableInfo info = m.apply(new RevisionResource(new ChangeResource(control), ps));
                Boolean bl = this.change.isMergeable() != info.mergeable;
                return bl;
            }
            catch (ResourceConflictException e) {
                Boolean bl = false;
                return bl;
            }
            finally {
                MergeabilityChecker.this.tl.setContext(old);
                if (this.reviewDb != null) {
                    this.reviewDb.close();
                    this.reviewDb = null;
                }
            }
        }
    }
}

