/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.PersonIdent;

public class Revert
implements RestModifyView<ChangeResource, RevertInput>,
UiAction<ChangeResource> {
    private final ChangeJson json;
    private final ChangeUtil changeUtil;
    private final PersonIdent myIdent;

    @Inject
    Revert(ChangeJson json, ChangeUtil changeUtil, @GerritPersonIdent PersonIdent myIdent) {
        this.json = json;
        this.changeUtil = changeUtil;
        this.myIdent = myIdent;
    }

    public ChangeJson.ChangeInfo apply(ChangeResource req, RevertInput input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, IOException, OrmException, EmailException {
        ChangeControl control = req.getControl();
        Change change = req.getChange();
        if (!control.canAddPatchSet()) {
            throw new AuthException("revert not permitted");
        }
        if (change.getStatus() != Change.Status.MERGED) {
            throw new ResourceConflictException("change is " + Revert.status(change));
        }
        try {
            Change.Id revertedChangeId = this.changeUtil.revert(control, change.currentPatchSetId(), Strings.emptyToNull(input.message), this.myIdent, new NoSshInfo());
            return this.json.format(revertedChangeId);
        }
        catch (InvalidChangeOperationException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Revert").setTitle("Revert the change").setVisible(resource.getChange().getStatus() == Change.Status.MERGED && resource.getControl().getRefControl().canUpload());
    }

    private static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }
}

