/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Revisions
implements ChildCollection<ChangeResource, RevisionResource> {
    private final DynamicMap<RestView<RevisionResource>> views;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    Revisions(DynamicMap<RestView<RevisionResource>> views, Provider<ReviewDb> dbProvider) {
        this.views = views;
        this.dbProvider = dbProvider;
    }

    @Override
    public DynamicMap<RestView<RevisionResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ChangeResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public RevisionResource parse(ChangeResource change, IdString id) throws ResourceNotFoundException, OrmException {
        if (id.equals("current")) {
            PatchSet ps;
            PatchSet.Id p = change.getChange().currentPatchSetId();
            PatchSet patchSet = ps = p != null ? this.dbProvider.get().patchSets().get(p) : null;
            if (ps != null && this.visible(change, ps)) {
                return new RevisionResource(change, ps).doNotCache();
            }
            throw new ResourceNotFoundException(id);
        }
        ArrayList<PatchSet> match = Lists.newArrayListWithExpectedSize(2);
        for (PatchSet ps : this.find(change, id.get())) {
            Change.Id changeId = ps.getId().getParentKey();
            if (!changeId.equals(change.getChange().getId()) || !this.visible(change, ps)) continue;
            match.add(ps);
        }
        if (match.size() != 1) {
            throw new ResourceNotFoundException(id);
        }
        return new RevisionResource(change, (PatchSet)match.get(0));
    }

    private boolean visible(ChangeResource change, PatchSet ps) throws OrmException {
        return change.getControl().isPatchVisible(ps, this.dbProvider.get());
    }

    private List<PatchSet> find(ChangeResource change, String id) throws OrmException {
        ReviewDb db = this.dbProvider.get();
        if (id.length() < 6 && id.matches("^[1-9][0-9]{0,4}$")) {
            PatchSet ps = this.dbProvider.get().patchSets().get(new PatchSet.Id(change.getChange().getId(), Integer.parseInt(id)));
            if (ps != null) {
                return Collections.singletonList(ps);
            }
            return Collections.emptyList();
        }
        if (id.length() < 4 || id.length() > 40) {
            return Collections.emptyList();
        }
        if (id.length() >= 8) {
            RevId revid = new RevId(id);
            if (revid.isComplete()) {
                return db.patchSets().byRevision(revid).toList();
            }
            return db.patchSets().byRevisionRange(revid, revid.max()).toList();
        }
        ArrayList<PatchSet> out = Lists.newArrayList();
        for (PatchSet ps : db.patchSets().byChange(change.getChange().getId())) {
            if (ps.getRevision() == null || !ps.getRevision().get().startsWith(id)) continue;
            out.add(ps);
        }
        return out;
    }
}

