/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.util.StringUtils;

public class ConfigUtil {
    public static <T extends Enum<?>> T getEnum(Config config, String section, String subsection, String setting, T defaultValue) {
        Enum[] all = ConfigUtil.allValuesOf(defaultValue);
        return (T)ConfigUtil.getEnum((Config)config, (String)section, (String)subsection, (String)setting, (Enum[])all, defaultValue);
    }

    private static <T> T[] allValuesOf(T defaultValue) {
        try {
            return (Object[])defaultValue.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
    }

    public static <T extends Enum<?>> T getEnum(Config config, String section, String subsection, String setting, T[] all, T defaultValue) {
        String valueString = config.getString(section, subsection, setting);
        if (valueString == null) {
            return defaultValue;
        }
        return (T)ConfigUtil.getEnum((String)section, (String)subsection, (String)setting, (String)valueString, all);
    }

    private static <T extends Enum<?>> T getEnum(String section, String subsection, String setting, String valueString, T[] all) {
        String n = valueString.replace(' ', '_').replace('-', '_');
        for (T e : all) {
            if (!StringUtils.equalsIgnoreCase(((Enum)e).name(), n)) continue;
            return e;
        }
        StringBuilder r = new StringBuilder();
        r.append("Value \"");
        r.append(valueString);
        r.append("\" not recognized in ");
        r.append(section);
        if (subsection != null) {
            r.append(".");
            r.append(subsection);
        }
        r.append(".");
        r.append(setting);
        r.append("; supported values are: ");
        for (T e : all) {
            r.append(((Enum)e).name());
            r.append(" ");
        }
        throw new IllegalArgumentException(r.toString().trim());
    }

    public static <T extends Enum<?>> List<T> getEnumList(Config config, String section, String subsection, String setting, T defaultValue) {
        Enum[] all = ConfigUtil.allValuesOf(defaultValue);
        return ConfigUtil.getEnumList((Config)config, (String)section, (String)subsection, (String)setting, (Enum[])all, defaultValue);
    }

    public static <T extends Enum<?>> List<T> getEnumList(Config config, String section, String subsection, String setting, T[] all, T defaultValue) {
        ArrayList<Enum> list = new ArrayList<Enum>();
        String[] values = config.getStringList(section, subsection, setting);
        if (values.length == 0) {
            list.add(defaultValue);
        } else {
            for (String string : values) {
                if (string == null) continue;
                list.add(ConfigUtil.getEnum((String)section, (String)subsection, (String)setting, (String)string, all));
            }
        }
        return list;
    }

    public static long getTimeUnit(Config config, String section, String subsection, String setting, long defaultValue, TimeUnit wantUnit) {
        String valueString = config.getString(section, subsection, setting);
        if (valueString == null) {
            return defaultValue;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            return ConfigUtil.getTimeUnit(s, defaultValue, wantUnit);
        }
        catch (IllegalArgumentException notTime) {
            throw ConfigUtil.notTimeUnit(section, subsection, setting, valueString);
        }
    }

    public static long getTimeUnit(String valueString, long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        Matcher m = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        if ("".equals(unitName)) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (ConfigUtil.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (ConfigUtil.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw ConfigUtil.notTimeUnit(valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            throw ConfigUtil.notTimeUnit(valueString);
        }
    }

    public static String getRequired(Config cfg, String section, String name) {
        String v = cfg.getString(section, null, name);
        if (v == null || "".equals(v)) {
            throw new IllegalArgumentException("No " + section + "." + name + " configured");
        }
        return v;
    }

    private static boolean match(String a, String ... cases) {
        for (String b : cases) {
            if (!StringUtils.equalsIgnoreCase(a, b)) continue;
            return true;
        }
        return false;
    }

    private static IllegalArgumentException notTimeUnit(String section, String subsection, String setting, String valueString) {
        return new IllegalArgumentException("Invalid time unit value: " + section + (subsection != null ? "." + subsection : "") + "." + setting + " = " + valueString);
    }

    private static IllegalArgumentException notTimeUnit(String val) {
        return new IllegalArgumentException("Invalid time unit value: " + val);
    }

    private ConfigUtil() {
    }
}

