/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.groups.ListGroupsOption;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupOptionsInfo;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.ListIncludedGroups;
import com.google.gerrit.server.group.ListMembers;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class GroupJson {
    private final GroupBackend groupBackend;
    private final GroupControl.Factory groupControlFactory;
    private final Provider<ListMembers> listMembers;
    private final Provider<ListIncludedGroups> listIncludes;
    private EnumSet<ListGroupsOption> options;

    @Inject
    GroupJson(GroupBackend groupBackend, GroupControl.Factory groupControlFactory, Provider<ListMembers> listMembers, Provider<ListIncludedGroups> listIncludes) {
        this.groupBackend = groupBackend;
        this.groupControlFactory = groupControlFactory;
        this.listMembers = listMembers;
        this.listIncludes = listIncludes;
        this.options = EnumSet.noneOf(ListGroupsOption.class);
    }

    public GroupJson addOption(ListGroupsOption o) {
        this.options.add(o);
        return this;
    }

    public GroupJson addOptions(Collection<ListGroupsOption> o) {
        this.options.addAll(o);
        return this;
    }

    public GroupInfo format(GroupResource rsrc) throws OrmException {
        GroupInfo info = this.init(rsrc.getGroup());
        this.initMembersAndIncludes(rsrc, info);
        return info;
    }

    public GroupInfo format(GroupDescription.Basic group) throws OrmException {
        GroupInfo info = this.init(group);
        if (this.options.contains((Object)ListGroupsOption.MEMBERS) || this.options.contains((Object)ListGroupsOption.INCLUDES)) {
            GroupResource rsrc = new GroupResource(this.groupControlFactory.controlFor(group));
            this.initMembersAndIncludes(rsrc, info);
        }
        return info;
    }

    private GroupInfo init(GroupDescription.Basic group) {
        GroupInfo info = new GroupInfo();
        info.id = Url.encode(group.getGroupUUID().get());
        info.name = Strings.emptyToNull(group.getName());
        info.url = Strings.emptyToNull(group.getUrl());
        info.options = new GroupOptionsInfo(group);
        AccountGroup g = GroupDescriptions.toAccountGroup(group);
        if (g != null) {
            info.description = Strings.emptyToNull(g.getDescription());
            info.groupId = g.getId().get();
            if (g.getOwnerGroupUUID() != null) {
                info.ownerId = Url.encode(g.getOwnerGroupUUID().get());
                GroupDescription.Basic o = this.groupBackend.get(g.getOwnerGroupUUID());
                if (o != null) {
                    info.owner = o.getName();
                }
            }
        }
        return info;
    }

    private GroupInfo initMembersAndIncludes(GroupResource rsrc, GroupInfo info) throws OrmException {
        if (rsrc.toAccountGroup() == null) {
            return info;
        }
        try {
            if (this.options.contains((Object)ListGroupsOption.MEMBERS)) {
                info.members = this.listMembers.get().apply(rsrc);
            }
            if (this.options.contains((Object)ListGroupsOption.INCLUDES)) {
                info.includes = this.listIncludes.get().apply(rsrc);
            }
            return info;
        }
        catch (MethodNotAllowedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class GroupBaseInfo {
        public String id;
        public String name;
    }

    public static class GroupInfo
    extends GroupBaseInfo {
        final String kind = "gerritcodereview#group";
        public String url;
        public GroupOptionsInfo options;
        public String description;
        public Integer groupId;
        public String owner;
        public String ownerId;
        public List<AccountInfo> members;
        public List<GroupInfo> includes;
    }
}

