/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gerrit.server.group.ListIncludedGroups;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class IncludedGroupsCollection
implements ChildCollection<GroupResource, IncludedGroupResource>,
AcceptsCreate<GroupResource> {
    private final DynamicMap<RestView<IncludedGroupResource>> views;
    private final Provider<ListIncludedGroups> list;
    private final Provider<GroupsCollection> groupsCollection;
    private final Provider<ReviewDb> dbProvider;
    private final Provider<AddIncludedGroups> put;

    @Inject
    IncludedGroupsCollection(DynamicMap<RestView<IncludedGroupResource>> views, Provider<ListIncludedGroups> list, Provider<GroupsCollection> groupsCollection, Provider<ReviewDb> dbProvider, Provider<AddIncludedGroups> put) {
        this.views = views;
        this.list = list;
        this.groupsCollection = groupsCollection;
        this.dbProvider = dbProvider;
        this.put = put;
    }

    @Override
    public RestView<GroupResource> list() {
        return this.list.get();
    }

    @Override
    public IncludedGroupResource parse(GroupResource resource, IdString id) throws MethodNotAllowedException, AuthException, ResourceNotFoundException, OrmException {
        AccountGroup parent = resource.toAccountGroup();
        if (parent == null) {
            throw new MethodNotAllowedException();
        }
        GroupDescription.Basic member = this.groupsCollection.get().parse(TopLevelResource.INSTANCE, id).getGroup();
        if (this.isMember(parent, member) && resource.getControl().canSeeGroup(member.getGroupUUID())) {
            return new IncludedGroupResource(resource, member);
        }
        throw new ResourceNotFoundException(id);
    }

    private boolean isMember(AccountGroup parent, GroupDescription.Basic member) throws OrmException {
        return this.dbProvider.get().accountGroupById().get(new AccountGroupById.Key(parent.getId(), member.getGroupUUID())) != null;
    }

    public AddIncludedGroups.PutIncludedGroup create(GroupResource group, IdString id) {
        return new AddIncludedGroups.PutIncludedGroup(this.put, id.get());
    }

    @Override
    public DynamicMap<RestView<IncludedGroupResource>> views() {
        return this.views;
    }
}

