/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.common.groups.ListGroupsOption;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupComparator;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gson.reflect.TypeToken;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

public class ListGroups
implements RestReadView<TopLevelResource> {
    protected final GroupCache groupCache;
    private final GroupControl.Factory groupControlFactory;
    private final GroupControl.GenericFactory genericGroupControlFactory;
    private final Provider<IdentifiedUser> identifiedUser;
    private final IdentifiedUser.GenericFactory userFactory;
    private final Provider<GetGroups> accountGetGroups;
    private final GroupJson json;
    private EnumSet<ListGroupsOption> options;
    @Option(name="--project", aliases={"-p"}, usage="projects for which the groups should be listed")
    private final List<ProjectControl> projects = new ArrayList<ProjectControl>();
    @Option(name="--visible-to-all", usage="to list only groups that are visible to all registered users")
    private boolean visibleToAll;
    @Option(name="--user", aliases={"-u"}, usage="user for which the groups should be listed")
    private Account.Id user;
    @Option(name="--owned", usage="to list only groups that are owned by the specified user or by the calling user if no user was specifed")
    private boolean owned;
    private Set<AccountGroup.UUID> groupsToInspect = Sets.newHashSet();
    @Option(name="-m", metaVar="MATCH", usage="match group substring")
    private String matchSubstring;

    @Option(name="-q", usage="group to inspect")
    void addGroup(AccountGroup.UUID id) {
        this.groupsToInspect.add(id);
    }

    @Option(name="-o", usage="Output options per group")
    public void addOption(ListGroupsOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListGroupsOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    protected ListGroups(GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupControl.GenericFactory genericGroupControlFactory, Provider<IdentifiedUser> identifiedUser, IdentifiedUser.GenericFactory userFactory, Provider<GetGroups> accountGetGroups, GroupJson json) {
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.genericGroupControlFactory = genericGroupControlFactory;
        this.identifiedUser = identifiedUser;
        this.userFactory = userFactory;
        this.accountGetGroups = accountGetGroups;
        this.json = json;
        this.options = EnumSet.noneOf(ListGroupsOption.class);
    }

    public Account.Id getUser() {
        return this.user;
    }

    public List<ProjectControl> getProjects() {
        return this.projects;
    }

    @Override
    public Object apply(TopLevelResource resource) throws OrmException {
        TreeMap<String, GroupJson.GroupInfo> output = Maps.newTreeMap();
        for (GroupJson.GroupInfo info : this.get()) {
            output.put(Objects.firstNonNull(info.name, "Group " + Url.decode(info.id)), info);
            info.name = null;
        }
        return OutputFormat.JSON.newGson().toJsonTree(output, new TypeToken<Map<String, GroupJson.GroupInfo>>(){}.getType());
    }

    public List<GroupJson.GroupInfo> get() throws OrmException {
        List<GroupJson.GroupInfo> groupInfos;
        if (this.user != null) {
            groupInfos = this.owned ? this.getGroupsOwnedBy(this.userFactory.create(this.user)) : this.accountGetGroups.get().apply(new AccountResource(this.userFactory.create(this.user)));
        } else if (this.owned) {
            groupInfos = this.getGroupsOwnedBy(this.identifiedUser.get());
        } else {
            List<AccountGroup> groupList;
            if (!this.projects.isEmpty()) {
                HashMap<AccountGroup.UUID, AccountGroup> groups = Maps.newHashMap();
                for (ProjectControl projectControl : this.projects) {
                    Set<GroupReference> groupsRefs = projectControl.getAllGroups();
                    for (GroupReference groupRef : groupsRefs) {
                        AccountGroup group = this.groupCache.get(groupRef.getUUID());
                        if (group == null) continue;
                        groups.put(group.getGroupUUID(), group);
                    }
                }
                groupList = this.filterGroups(groups.values());
            } else {
                groupList = this.filterGroups(this.groupCache.all());
            }
            groupInfos = Lists.newArrayListWithCapacity(groupList.size());
            for (AccountGroup group : groupList) {
                groupInfos.add(this.json.addOptions(this.options).format(GroupDescriptions.forAccountGroup(group)));
            }
        }
        return groupInfos;
    }

    private List<GroupJson.GroupInfo> getGroupsOwnedBy(IdentifiedUser user) throws OrmException {
        ArrayList<GroupJson.GroupInfo> groups = Lists.newArrayList();
        for (AccountGroup g : this.filterGroups(this.groupCache.all())) {
            GroupControl ctl = this.groupControlFactory.controlFor(g);
            try {
                if (!this.genericGroupControlFactory.controlFor(user, g.getGroupUUID()).isOwner()) continue;
                groups.add(this.json.addOptions(this.options).format(ctl.getGroup()));
            }
            catch (NoSuchGroupException e) {}
        }
        return groups;
    }

    private List<AccountGroup> filterGroups(Iterable<AccountGroup> groups) {
        ArrayList<AccountGroup> filteredGroups = Lists.newArrayList();
        boolean isAdmin = this.identifiedUser.get().getCapabilities().canAdministrateServer();
        for (AccountGroup group : groups) {
            GroupControl c;
            if (!Strings.isNullOrEmpty(this.matchSubstring) && !group.getName().toLowerCase(Locale.US).contains(this.matchSubstring.toLowerCase(Locale.US)) || !isAdmin && !(c = this.groupControlFactory.controlFor(group)).isVisible() || this.visibleToAll && !group.isVisibleToAll() || !this.groupsToInspect.isEmpty() && !this.groupsToInspect.contains(group.getGroupUUID())) continue;
            filteredGroups.add(group);
        }
        Collections.sort(filteredGroups, new GroupComparator());
        return filteredGroups;
    }
}

