/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.plugins.InstallPlugin;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class PluginsCollection
implements RestCollection<TopLevelResource, PluginResource>,
AcceptsCreate<TopLevelResource> {
    private final DynamicMap<RestView<PluginResource>> views;
    private final PluginLoader loader;
    private final Provider<ListPlugins> list;

    @Inject
    PluginsCollection(DynamicMap<RestView<PluginResource>> views, PluginLoader loader, Provider<ListPlugins> list) {
        this.views = views;
        this.loader = loader;
        this.list = list;
    }

    @Override
    public RestView<TopLevelResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public PluginResource parse(TopLevelResource parent, IdString id) throws ResourceNotFoundException {
        Plugin p = this.loader.get(id.get());
        if (p == null) {
            throw new ResourceNotFoundException(id);
        }
        return new PluginResource(p);
    }

    public InstallPlugin create(TopLevelResource parent, IdString id) throws ResourceNotFoundException, MethodNotAllowedException {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw new MethodNotAllowedException("remote installation is disabled");
        }
        return new InstallPlugin(this.loader, id.get(), true);
    }

    @Override
    public DynamicMap<RestView<PluginResource>> views() {
        return this.views;
    }
}

