/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.errors.InvalidRevisionException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ListBranches;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.util.MagicBranch;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBranch
implements RestModifyView<ProjectResource, Input> {
    private static final Logger log = LoggerFactory.getLogger(CreateBranch.class);
    private final IdentifiedUser identifiedUser;
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated referenceUpdated;
    private final ChangeHooks hooks;
    private String ref;

    @Inject
    CreateBranch(IdentifiedUser identifiedUser, GitRepositoryManager repoManager, GitReferenceUpdated referenceUpdated, ChangeHooks hooks, @Assisted String ref) {
        this.identifiedUser = identifiedUser;
        this.repoManager = repoManager;
        this.referenceUpdated = referenceUpdated;
        this.hooks = hooks;
        this.ref = ref;
    }

    public ListBranches.BranchInfo apply(ProjectResource rsrc, Input input) throws BadRequestException, AuthException, ResourceConflictException, IOException {
        if (input == null) {
            input = new Input();
        }
        if (input.ref != null && !this.ref.equals(input.ref)) {
            throw new BadRequestException("ref must match URL");
        }
        if (input.revision == null) {
            input.revision = "HEAD";
        }
        while (this.ref.startsWith("/")) {
            this.ref = this.ref.substring(1);
        }
        if (!this.ref.startsWith("refs/")) {
            this.ref = "refs/heads/" + this.ref;
        }
        if (!Repository.isValidRefName(this.ref)) {
            throw new BadRequestException("invalid branch name \"" + this.ref + "\"");
        }
        if (MagicBranch.isMagicBranch(this.ref)) {
            throw new BadRequestException("not allowed to create branches under \"" + MagicBranch.getMagicRefNamePrefix(this.ref) + "\"");
        }
        Branch.NameKey name = new Branch.NameKey(rsrc.getNameKey(), this.ref);
        RefControl refControl = rsrc.getControl().controlForRef(name);
        try (Repository repo = this.repoManager.openRepository(rsrc.getNameKey());){
            ObjectId revid = this.parseBaseRevision(repo, rsrc.getNameKey(), input.revision);
            RevWalk rw = this.verifyConnected(repo, revid);
            RevObject object = rw.parseAny(revid);
            if (this.ref.startsWith("refs/heads/")) {
                try {
                    object = rw.parseCommit(object);
                }
                catch (IncorrectObjectTypeException notCommit) {
                    throw new BadRequestException("\"" + input.revision + "\" not a commit");
                }
            }
            if (!refControl.canCreate(rw, object, true)) {
                throw new AuthException("Cannot create \"" + this.ref + "\"");
            }
            try {
                RefUpdate u = repo.updateRef(this.ref);
                u.setExpectedOldObjectId(ObjectId.zeroId());
                u.setNewObjectId(object.copy());
                u.setRefLogIdent(this.identifiedUser.newRefLogIdent());
                u.setRefLogMessage("created via REST from " + input.revision, false);
                RefUpdate.Result result = u.update(rw);
                switch (result) {
                    case FAST_FORWARD: 
                    case NEW: 
                    case NO_CHANGE: {
                        this.referenceUpdated.fire(name.getParentKey(), u);
                        this.hooks.doRefUpdatedHook(name, u, this.identifiedUser.getAccount());
                        break;
                    }
                    case LOCK_FAILURE: {
                        if (repo.getRef(this.ref) != null) {
                            throw new ResourceConflictException("branch \"" + this.ref + "\" already exists");
                        }
                        String refPrefix = CreateBranch.getRefPrefix(this.ref);
                        while (!"refs/heads/".equals(refPrefix)) {
                            if (repo.getRef(refPrefix) != null) {
                                throw new ResourceConflictException("Cannot create branch \"" + this.ref + "\" since it conflicts with branch \"" + refPrefix + "\".");
                            }
                            refPrefix = CreateBranch.getRefPrefix(refPrefix);
                        }
                    }
                    default: {
                        throw new IOException(result.name());
                    }
                }
                ListBranches.BranchInfo branchInfo = new ListBranches.BranchInfo(this.ref, revid.getName(), refControl.canDelete());
                return branchInfo;
            }
            catch (IOException err) {
                try {
                    log.error("Cannot create branch \"" + name + "\"", err);
                    throw err;
                }
                catch (InvalidRevisionException e) {
                    throw new BadRequestException("invalid revision \"" + input.revision + "\"");
                }
            }
        }
    }

    private static String getRefPrefix(String refName) {
        int i = refName.lastIndexOf(47);
        if (i > "refs/heads/".length() - 1) {
            return refName.substring(0, i);
        }
        return "refs/heads/";
    }

    private ObjectId parseBaseRevision(Repository repo, Project.NameKey projectName, String baseRevision) throws InvalidRevisionException {
        try {
            ObjectId revid = repo.resolve(baseRevision);
            if (revid == null) {
                throw new InvalidRevisionException();
            }
            return revid;
        }
        catch (IOException err) {
            log.error("Cannot resolve \"" + baseRevision + "\" in project \"" + projectName.get() + "\"", err);
            throw new InvalidRevisionException();
        }
        catch (RevisionSyntaxException err) {
            log.error("Invalid revision syntax \"" + baseRevision + "\"", err);
            throw new InvalidRevisionException();
        }
    }

    private RevWalk verifyConnected(Repository repo, ObjectId revid) throws InvalidRevisionException {
        try {
            ObjectWalk rw = new ObjectWalk(repo);
            try {
                rw.markStart(rw.parseCommit(revid));
            }
            catch (IncorrectObjectTypeException err) {
                throw new InvalidRevisionException();
            }
            for (Ref r : repo.getRefDatabase().getRefs("").values()) {
                try {
                    rw.markUninteresting(rw.parseAny(r.getObjectId()));
                }
                catch (MissingObjectException err) {}
            }
            rw.checkConnectivity();
            return rw;
        }
        catch (IncorrectObjectTypeException err) {
            throw new InvalidRevisionException();
        }
        catch (MissingObjectException err) {
            throw new InvalidRevisionException();
        }
        catch (IOException err) {
            log.error("Repository \"" + repo.getDirectory() + "\" may be corrupt; suggest running git fsck", err);
            throw new InvalidRevisionException();
        }
    }

    public static interface Factory {
        public CreateBranch create(String var1);
    }

    public static class Input {
        public String ref;
        @DefaultInput
        public String revision;
    }
}

