/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

public class SetParent
implements RestModifyView<ProjectResource, Input> {
    private final ProjectCache cache;
    private final MetaDataUpdate.Server updateFactory;
    private final AllProjectsName allProjects;

    @Inject
    SetParent(ProjectCache cache, MetaDataUpdate.Server updateFactory, AllProjectsName allProjects) {
        this.cache = cache;
        this.updateFactory = updateFactory;
        this.allProjects = allProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apply(ProjectResource rsrc, Input input) throws AuthException, ResourceConflictException, ResourceNotFoundException, UnprocessableEntityException, IOException {
        ProjectControl ctl = rsrc.getControl();
        this.validateParentUpdate(ctl, input.parent, true);
        IdentifiedUser user = (IdentifiedUser)ctl.getCurrentUser();
        MetaDataUpdate md = this.updateFactory.create(rsrc.getNameKey());
        try {
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setParentName(Strings.emptyToNull(input.parent));
            String msg = Strings.emptyToNull(input.commitMessage);
            if (msg == null) {
                msg = String.format("Changed parent to %s.\n", Objects.firstNonNull(project.getParentName(), this.allProjects.get()));
            } else if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(user);
            md.setMessage(msg);
            config.commit(md);
            this.cache.evict(ctl.getProject());
            Project.NameKey parentName = project.getParent(this.allProjects);
            String string = parentName != null ? parentName.get() : "";
            md.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                md.close();
                throw throwable;
            }
            catch (RepositoryNotFoundException notFound) {
                throw new ResourceNotFoundException(rsrc.getName());
            }
            catch (ConfigInvalidException e) {
                throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
            }
        }
    }

    public void validateParentUpdate(final ProjectControl ctl, String newParent, boolean checkIfAdmin) throws AuthException, ResourceConflictException, UnprocessableEntityException {
        IdentifiedUser user = (IdentifiedUser)ctl.getCurrentUser();
        if (checkIfAdmin && !user.getCapabilities().canAdministrateServer()) {
            throw new AuthException("not administrator");
        }
        if (ctl.getProject().getNameKey().equals(this.allProjects)) {
            throw new ResourceConflictException("cannot set parent of " + this.allProjects.get());
        }
        if ((newParent = Strings.emptyToNull(newParent)) != null) {
            ProjectState parent = this.cache.get(new Project.NameKey(newParent));
            if (parent == null) {
                throw new UnprocessableEntityException("parent project " + newParent + " not found");
            }
            if (Iterables.tryFind(parent.tree(), new Predicate<ProjectState>(){

                @Override
                public boolean apply(ProjectState input) {
                    return input.getProject().getNameKey().equals(ctl.getProject().getNameKey());
                }
            }).isPresent()) {
                throw new ResourceConflictException("cycle exists between " + ctl.getProject().getName() + " and " + parent.getProject().getName());
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String parent;
        public String commitMessage;
    }
}

