/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_68;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_69
extends SchemaVersion {
    private final GitRepositoryManager mgr;
    private final PersonIdent serverUser;

    @Inject
    Schema_69(Provider<Schema_68> prior, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.mgr = mgr;
        this.serverUser = serverUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        AccountGroup group;
        GroupReference ref;
        HashMap<AccountGroup.UUID, GroupReference> ldapUUIDMap = Maps.newHashMap();
        HashSet<AccountGroup.UUID> toResolve = Sets.newHashSet();
        ArrayList<AccountGroup.Id> toDelete = Lists.newArrayList();
        ArrayList<AccountGroup.NameKey> namesToDelete = Lists.newArrayList();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
             ResultSet rs = stmt.executeQuery("SELECT group_id, group_uuid, external_name, name FROM account_groups WHERE group_type ='LDAP'");){
            while (rs.next()) {
                AccountGroup.Id groupId = new AccountGroup.Id(rs.getInt(1));
                AccountGroup.UUID groupUUID = new AccountGroup.UUID(rs.getString(2));
                AccountGroup.NameKey name = new AccountGroup.NameKey(rs.getString(4));
                String dn = rs.getString(3);
                if (Strings.isNullOrEmpty(dn)) {
                    toResolve.add(groupUUID);
                    continue;
                }
                toDelete.add(groupId);
                namesToDelete.add(name);
                ref = Schema_69.groupReference(dn);
                ldapUUIDMap.put(groupUUID, ref);
            }
        }
        if (toDelete.isEmpty() && toResolve.isEmpty()) {
            return;
        }
        ui.message("Update LDAP groups to be GroupReferences.");
        ArrayList<AccountGroup> toUpdate = Lists.newArrayList();
        HashSet<AccountGroup.UUID> resolveToUpdate = Sets.newHashSet();
        HashMap<AccountGroup.UUID, AccountGroup> resolveGroups = Maps.newHashMap();
        for (AccountGroup g : db.accountGroups().all()) {
            if (ldapUUIDMap.containsKey(g.getGroupUUID())) continue;
            if (toResolve.contains(g.getGroupUUID())) {
                resolveGroups.put(g.getGroupUUID(), g);
                continue;
            }
            ref = (GroupReference)ldapUUIDMap.get(g.getOwnerGroupUUID());
            if (ref != null) {
                g.setOwnerGroupUUID(ref.getUUID());
                toUpdate.add(g);
                continue;
            }
            if (!toResolve.contains(g.getOwnerGroupUUID())) continue;
            resolveToUpdate.add(g.getOwnerGroupUUID());
        }
        toResolve.removeAll(resolveToUpdate);
        for (Project.NameKey name : this.mgr.list()) {
            Repository git;
            try {
                git = this.mgr.openRepository(name);
            }
            catch (RepositoryNotFoundException e) {
                throw new OrmException(e);
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            try {
                MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, name, git);
                md.getCommitBuilder().setAuthor(this.serverUser);
                md.getCommitBuilder().setCommitter(this.serverUser);
                ProjectConfig config = ProjectConfig.read(md);
                boolean updated = false;
                for (Map.Entry entry : ldapUUIDMap.entrySet()) {
                    GroupReference ref2 = config.getGroup((AccountGroup.UUID)entry.getKey());
                    if (ref2 == null) continue;
                    updated = true;
                    ref2.setName(((GroupReference)entry.getValue()).getName());
                    ref2.setUUID(((GroupReference)entry.getValue()).getUUID());
                    config.resolve(ref2);
                }
                Iterator iter = toResolve.iterator();
                while (iter.hasNext()) {
                    AccountGroup.UUID uuid = (AccountGroup.UUID)iter.next();
                    if (config.getGroup(uuid) == null) continue;
                    resolveToUpdate.add(uuid);
                    iter.remove();
                }
                if (!updated) continue;
                md.setMessage("Switch LDAP group UUIDs to DNs\n");
                config.commit(md);
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            catch (ConfigInvalidException e) {
                throw new OrmException(e);
            }
            finally {
                git.close();
            }
        }
        for (AccountGroup.UUID uuid : resolveToUpdate) {
            group = (AccountGroup)resolveGroups.get(uuid);
            ui.message(String.format("*** Group has no DN and is in use: %s", group.getName()));
        }
        for (AccountGroup.UUID uuid : toResolve) {
            group = (AccountGroup)resolveGroups.get(uuid);
            toDelete.add(group.getId());
            namesToDelete.add(group.getNameKey());
        }
        db.accountGroups().update(toUpdate);
        db.accountGroupNames().deleteKeys(namesToDelete);
        db.accountGroups().deleteKeys(toDelete);
    }

    private static GroupReference groupReference(String dn) throws NamingException {
        LdapName name = new LdapName(dn);
        Preconditions.checkState(!name.isEmpty(), "Invalid LDAP dn: %s", dn);
        String cn = name.get(name.size() - 1);
        int index = cn.indexOf(61);
        if (index >= 0) {
            cn = cn.substring(index + 1);
        }
        return new GroupReference(new AccountGroup.UUID("ldap:" + dn), "ldap/" + cn);
    }
}

