/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_76;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.sql.DialectH2;
import com.google.gwtorm.schema.sql.DialectMySQL;
import com.google.gwtorm.schema.sql.DialectPostgreSQL;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_77
extends SchemaVersion {
    private final GitRepositoryManager mgr;
    private final AllProjectsName allProjects;
    private final PersonIdent serverUser;

    @Inject
    Schema_77(Provider<Schema_76> prior, AllProjectsName allProjects, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.allProjects = allProjects;
        this.mgr = mgr;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try {
            LegacyLabelTypes labelTypes = Schema_77.getLegacyTypes(db);
            SqlDialect dialect = ((JdbcSchema)((Object)db)).getDialect();
            if (dialect instanceof DialectH2) {
                this.alterTable(db, "ALTER TABLE %s ALTER COLUMN %s varchar(255)");
            } else if (dialect instanceof DialectPostgreSQL) {
                this.alterTable(db, "ALTER TABLE %s ALTER %s TYPE varchar(255)");
            } else if (dialect instanceof DialectMySQL) {
                this.alterTable(db, "ALTER TABLE %s MODIFY %s varchar(255) BINARY");
            } else {
                this.alterTable(db, "ALTER TABLE %s MODIFY %s varchar(255)");
            }
            this.migratePatchSetApprovals(db, labelTypes);
            this.migrateLabelsToAllProjects(db, labelTypes);
        }
        catch (RepositoryNotFoundException e) {
            throw new OrmException(e);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
        ui.message("Migrated label types from database to All-Projects project.config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTable(ReviewDb db, String sqlFormat) throws SQLException {
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            stmt.executeUpdate(String.format(sqlFormat, "patch_set_approvals", "category_id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateLabelsToAllProjects(ReviewDb db, LegacyLabelTypes labelTypes) throws SQLException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        try (Repository git = this.mgr.openRepository(this.allProjects);){
            MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjects, git);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            ProjectConfig config = ProjectConfig.read(md);
            Map<String, LabelType> configTypes = config.getLabelSections();
            ArrayList<LabelType> newTypes = Lists.newArrayList();
            for (LegacyLabelType legacyLabelType : labelTypes.getLegacyLabelTypes()) {
                if (configTypes.containsKey(legacyLabelType.getName())) continue;
                newTypes.add(legacyLabelType);
            }
            newTypes.addAll(configTypes.values());
            configTypes.clear();
            for (LabelType labelType : newTypes) {
                configTypes.put(labelType.getName(), labelType);
            }
            md.setMessage("Upgrade to Gerrit Code Review schema 77\n");
            config.commit(md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migratePatchSetApprovals(ReviewDb db, LegacyLabelTypes labelTypes) throws SQLException {
        try (PreparedStatement stmt = ((JdbcSchema)((Object)db)).getConnection().prepareStatement("UPDATE patch_set_approvals SET category_id = ? WHERE category_id = ?");){
            for (LegacyLabelType type : labelTypes.getLegacyLabelTypes()) {
                stmt.setString(1, type.getName());
                stmt.setString(2, type.getId());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LegacyLabelTypes getLegacyTypes(ReviewDb db) throws SQLException {
        ArrayList<LegacyLabelType> types = Lists.newArrayListWithCapacity(2);
        try (Statement catStmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            ResultSet catRs = catStmt.executeQuery("SELECT category_id, name, abbreviated_name, function_name,  copy_min_score FROM approval_categories ORDER BY position, name");
            try (PreparedStatement valStmt = ((JdbcSchema)((Object)db)).getConnection().prepareStatement("SELECT value, name FROM approval_category_values WHERE category_id = ?");){
                while (catRs.next()) {
                    String id = catRs.getString("category_id");
                    valStmt.setString(1, id);
                    ArrayList<LabelValue> values = Lists.newArrayListWithCapacity(5);
                    ResultSet valRs = valStmt.executeQuery();
                    while (valRs.next()) {
                        values.add(new LabelValue(valRs.getShort("value"), valRs.getString("name")));
                    }
                    LegacyLabelType type = new LegacyLabelType(Schema_77.getLabelName(catRs.getString("name")), values);
                    type.setId(id);
                    type.setAbbreviation(catRs.getString("abbreviated_name"));
                    type.setFunctionName(catRs.getString("function_name"));
                    type.setCopyMinScore("Y".equals(catRs.getString("copy_min_score")));
                    types.add(type);
                }
            }
        }
        return new LegacyLabelTypes(types);
    }

    private static String getLabelName(String name) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-') {
                r.append(c);
                continue;
            }
            if (c != ' ') continue;
            r.append('-');
        }
        return r.toString();
    }

    static class LegacyLabelTypes
    extends LabelTypes {
        private final List<LegacyLabelType> legacyTypes;
        private final Map<String, LegacyLabelType> byId;

        private LegacyLabelTypes(List<LegacyLabelType> types) {
            super(types);
            this.legacyTypes = types;
            this.byId = Maps.newHashMap();
            for (LegacyLabelType type : types) {
                this.byId.put(type.getId(), type);
            }
        }

        List<LegacyLabelType> getLegacyLabelTypes() {
            return this.legacyTypes;
        }

        @Override
        public LegacyLabelType byLabel(PatchSetApproval.LabelId labelId) {
            LegacyLabelType t = this.byId.get(labelId.get());
            return t != null ? t : (LegacyLabelType)super.byLabel(labelId);
        }

        LegacyLabelType byId(PatchSetApproval.LabelId id) {
            return this.byId.get(id.get());
        }
    }

    static class LegacyLabelType
    extends LabelType {
        private String id;

        private LegacyLabelType(String name, List<LabelValue> values) {
            super(name, values);
        }

        String getId() {
            return this.id;
        }

        private void setId(String id) {
            Preconditions.checkArgument(id.length() <= 4, "Invalid legacy label ID: \"%s\"", id);
            this.id = id;
        }
    }
}

