/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.CurrentUser;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.sshd.common.Session;

public class SshSession {
    public static final Session.AttributeKey<SshSession> KEY = new Session.AttributeKey();
    private final int sessionId;
    private final SocketAddress remoteAddress;
    private final String remoteAsString;
    private volatile CurrentUser identity;
    private volatile String username;
    private volatile String authError;

    SshSession(int sessionId, SocketAddress peer) {
        this.sessionId = sessionId;
        this.remoteAddress = peer;
        this.remoteAsString = SshSession.format(this.remoteAddress);
    }

    SshSession(SshSession parent, SocketAddress peer, CurrentUser user) {
        user.setAccessPath(AccessPath.SSH_COMMAND);
        this.sessionId = parent.sessionId;
        this.remoteAddress = peer;
        this.remoteAsString = parent.remoteAddress == peer ? parent.remoteAsString : SshSession.format(peer) + "/" + parent.remoteAsString;
        this.identity = user;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public CurrentUser getCurrentUser() {
        return this.identity;
    }

    String getUsername() {
        return this.username;
    }

    String getAuthenticationError() {
        return this.authError;
    }

    void authenticationSuccess(String user, CurrentUser id) {
        this.username = user;
        this.identity = id;
        this.identity.setAccessPath(AccessPath.SSH_COMMAND);
        this.authError = null;
    }

    void authenticationError(String user, String error) {
        this.username = user;
        this.identity = null;
        this.authError = error;
    }

    void setAccessPath(AccessPath path) {
        this.identity.setAccessPath(path);
    }

    boolean isAuthenticationError() {
        return this.authError != null;
    }

    SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    String getRemoteAddressAsString() {
        return this.remoteAsString;
    }

    private static String format(SocketAddress remote) {
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress sa = (InetSocketAddress)remote;
            InetAddress in = sa.getAddress();
            if (in != null) {
                return in.getHostAddress();
            }
            String hostName = sa.getHostName();
            if (hostName != null) {
                return hostName;
            }
        }
        return remote.toString();
    }
}

