/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.commands.ApproveOption;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="review", description="Verify, approve and/or submit one or more patch sets")
public class ReviewCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(ReviewCommand.class);
    private final Set<PatchSet> patchSets = new HashSet<PatchSet>();
    @Option(name="--project", aliases={"-p"}, usage="project containing the specified patch set(s)")
    private ProjectControl projectControl;
    @Option(name="--branch", aliases={"-b"}, usage="branch containing the specified patch set(s)")
    private String branch;
    @Option(name="--message", aliases={"-m"}, usage="cover message to publish on change(s)", metaVar="MESSAGE")
    private String changeComment;
    @Option(name="--notify", aliases={"-n"}, usage="Who to send email notifications to after the review is stored.", metaVar="NOTIFYHANDLING")
    private ReviewInput.NotifyHandling notify;
    @Option(name="--abandon", usage="abandon the specified change(s)")
    private boolean abandonChange;
    @Option(name="--restore", usage="restore the specified abandoned change(s)")
    private boolean restoreChange;
    @Option(name="--submit", aliases={"-s"}, usage="submit the specified patch set(s)")
    private boolean submitChange;
    @Option(name="--publish", usage="publish the specified draft patch set(s)")
    private boolean publishPatchSet;
    @Option(name="--delete", usage="delete the specified draft patch set(s)")
    private boolean deleteDraftPatchSet;
    @Inject
    private ReviewDb db;
    @Inject
    private ProjectControl.Factory projectControlFactory;
    @Inject
    private AllProjectsName allProjects;
    @Inject
    private Provider<GerritApi> gApi;
    private List<ApproveOption> optionList;
    private Map<String, Short> customLabels;

    @Override
    protected final CmdLineParser newCmdLineParser(Object options) {
        CmdLineParser parser = super.newCmdLineParser(options);
        for (ApproveOption c : this.optionList) {
            parser.addOption(c, c);
        }
        return parser;
    }

    @Argument(index=0, required=true, multiValued=true, metaVar="{COMMIT | CHANGE,PATCHSET}", usage="list of commits or patch sets to review")
    void addPatchSetId(String token) {
        try {
            this.patchSets.add(this.parsePatchSet(token));
        }
        catch (BaseCommand.UnloggedFailure e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (OrmException e) {
            throw new IllegalArgumentException("database error", e);
        }
    }

    @Option(name="--label", aliases={"-l"}, usage="custom label(s) to assign", metaVar="LABEL=VALUE")
    void addLabel(String token) {
        LabelVote v = LabelVote.parseWithEquals(token);
        LabelType.checkName(v.getLabel());
        this.customLabels.put(v.getLabel(), v.getValue());
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        if (this.abandonChange) {
            if (this.restoreChange) {
                throw ReviewCommand.error("abandon and restore actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw ReviewCommand.error("abandon and submit actions are mutually exclusive");
            }
            if (this.publishPatchSet) {
                throw ReviewCommand.error("abandon and publish actions are mutually exclusive");
            }
            if (this.deleteDraftPatchSet) {
                throw ReviewCommand.error("abandon and delete actions are mutually exclusive");
            }
        }
        if (this.publishPatchSet) {
            if (this.restoreChange) {
                throw ReviewCommand.error("publish and restore actions are mutually exclusive");
            }
            if (this.submitChange) {
                throw ReviewCommand.error("publish and submit actions are mutually exclusive");
            }
            if (this.deleteDraftPatchSet) {
                throw ReviewCommand.error("publish and delete actions are mutually exclusive");
            }
        }
        boolean ok = true;
        for (PatchSet patchSet : this.patchSets) {
            try {
                this.approveOne(patchSet);
            }
            catch (BaseCommand.UnloggedFailure e) {
                ok = false;
                this.writeError("error: " + e.getMessage() + "\n");
            }
            catch (NoSuchChangeException e) {
                ok = false;
                this.writeError("no such change " + patchSet.getId().getParentKey().get());
            }
            catch (Exception e) {
                ok = false;
                this.writeError("fatal: internal server error while approving " + patchSet.getId() + "\n");
                log.error("internal error while approving " + patchSet.getId(), e);
            }
        }
        if (!ok) {
            throw new BaseCommand.UnloggedFailure(1, "one or more approvals failed; review output above");
        }
    }

    private void applyReview(PatchSet patchSet, ReviewInput review) throws Exception {
        this.gApi.get().changes().id(patchSet.getId().getParentKey().get()).revision(patchSet.getRevision().get()).review(review);
    }

    private void approveOne(PatchSet patchSet) throws Exception {
        if (this.changeComment == null) {
            this.changeComment = "";
        }
        ReviewInput review = new ReviewInput();
        review.message = Strings.emptyToNull(this.changeComment);
        review.notify = this.notify;
        review.labels = Maps.newTreeMap();
        review.drafts = ReviewInput.DraftHandling.PUBLISH;
        review.strictLabels = false;
        for (ApproveOption ao : this.optionList) {
            Short v = ao.value();
            if (v == null) continue;
            review.labels.put(ao.getLabelName(), v);
        }
        review.labels.putAll(this.customLabels);
        if (!review.labels.isEmpty() && (this.abandonChange || this.restoreChange)) {
            this.changeComment = null;
        }
        try {
            Object input;
            if (this.abandonChange) {
                input = new AbandonInput();
                ((AbandonInput)input).message = this.changeComment;
                this.applyReview(patchSet, review);
                this.changeApi(patchSet).abandon((AbandonInput)input);
            } else if (this.restoreChange) {
                input = new RestoreInput();
                ((RestoreInput)input).message = this.changeComment;
                this.changeApi(patchSet).restore((RestoreInput)input);
                this.applyReview(patchSet, review);
            } else {
                this.applyReview(patchSet, review);
            }
            if (this.submitChange) {
                this.revisionApi(patchSet).submit();
            }
            if (this.publishPatchSet) {
                this.revisionApi(patchSet).publish();
            } else if (this.deleteDraftPatchSet) {
                this.revisionApi(patchSet).delete();
            }
        }
        catch (InvalidChangeOperationException e) {
            throw ReviewCommand.error(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw ReviewCommand.error(e.getMessage());
        }
        catch (AuthException e) {
            throw ReviewCommand.error(e.getMessage());
        }
        catch (BadRequestException e) {
            throw ReviewCommand.error(e.getMessage());
        }
        catch (ResourceConflictException e) {
            throw ReviewCommand.error(e.getMessage());
        }
        catch (RestApiException e) {
            throw ReviewCommand.error(e.getMessage());
        }
    }

    private ChangeApi changeApi(PatchSet patchSet) throws RestApiException {
        return this.gApi.get().changes().id(patchSet.getId().getParentKey().get());
    }

    private RevisionApi revisionApi(PatchSet patchSet) throws RestApiException {
        return this.changeApi(patchSet).revision(patchSet.getRevision().get());
    }

    private PatchSet parsePatchSet(String patchIdentity) throws BaseCommand.UnloggedFailure, OrmException {
        if (patchIdentity.matches("^([0-9a-fA-F]{4,40})$")) {
            RevId id = new RevId(patchIdentity);
            ResultSet<PatchSet> patches = id.isComplete() ? this.db.patchSets().byRevision(id) : this.db.patchSets().byRevisionRange(id, id.max());
            HashSet<PatchSet> matches = new HashSet<PatchSet>();
            for (PatchSet ps : patches) {
                Change change = this.db.changes().get(ps.getId().getParentKey());
                if (!this.inProject(change) || !this.inBranch(change)) continue;
                matches.add(ps);
            }
            switch (matches.size()) {
                case 1: {
                    return (PatchSet)matches.iterator().next();
                }
                case 0: {
                    throw ReviewCommand.error("\"" + patchIdentity + "\" no such patch set");
                }
            }
            throw ReviewCommand.error("\"" + patchIdentity + "\" matches multiple patch sets");
        }
        if (patchIdentity.matches("^[1-9][0-9]*,[1-9][0-9]*$")) {
            PatchSet.Id patchSetId;
            try {
                patchSetId = PatchSet.Id.parse(patchIdentity);
            }
            catch (IllegalArgumentException e) {
                throw ReviewCommand.error("\"" + patchIdentity + "\" is not a valid patch set");
            }
            PatchSet patchSet = this.db.patchSets().get(patchSetId);
            if (patchSet == null) {
                throw ReviewCommand.error("\"" + patchIdentity + "\" no such patch set");
            }
            if (this.projectControl != null || this.branch != null) {
                Change change = this.db.changes().get(patchSetId.getParentKey());
                if (!this.inProject(change)) {
                    throw ReviewCommand.error("change " + change.getId() + " not in project " + this.projectControl.getProject().getName());
                }
                if (!this.inBranch(change)) {
                    throw ReviewCommand.error("change " + change.getId() + " not in branch " + change.getDest().get());
                }
            }
            return patchSet;
        }
        throw ReviewCommand.error("\"" + patchIdentity + "\" is not a valid patch set");
    }

    private boolean inProject(Change change) {
        if (this.projectControl == null) {
            return true;
        }
        return this.projectControl.getProject().getNameKey().equals(change.getProject());
    }

    private boolean inBranch(Change change) {
        if (this.branch == null) {
            return true;
        }
        return change.getDest().get().equals(this.branch);
    }

    @Override
    protected void parseCommandLine() throws BaseCommand.UnloggedFailure {
        ProjectControl allProjectsControl;
        this.optionList = new ArrayList<ApproveOption>();
        this.customLabels = Maps.newHashMap();
        try {
            allProjectsControl = this.projectControlFactory.controlFor(this.allProjects);
        }
        catch (NoSuchProjectException e) {
            throw new BaseCommand.UnloggedFailure("missing " + this.allProjects.get());
        }
        for (LabelType type : allProjectsControl.getLabelTypes().getLabelTypes()) {
            String usage = "score for " + type.getName() + "\n";
            for (LabelValue v : type.getValues()) {
                usage = usage + v.format() + "\n";
            }
            String name = "--" + type.getName().toLowerCase();
            this.optionList.add(new ApproveOption(name, usage, type));
        }
        super.parseCommandLine();
    }

    private void writeError(String msg) {
        try {
            this.err.write(msg.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BaseCommand.UnloggedFailure error(String msg) {
        return new BaseCommand.UnloggedFailure(1, msg);
    }
}

