/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Maps;
import com.google.gerrit.common.Version;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.cache.h2.H2CacheImpl;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshDaemon;
import com.google.gerrit.sshd.commands.CacheCommand;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.server.Environment;
import org.eclipse.jgit.internal.storage.file.WindowCacheStatAccessor;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="viewCaches")
@CommandMetaData(name="show-caches", description="Display current cache statistics", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ShowCaches
extends CacheCommand {
    private static volatile long serverStarted;
    @Option(name="--gc", usage="perform Java GC before printing memory stats")
    private boolean gc;
    @Option(name="--show-jvm", usage="show details about the JVM")
    private boolean showJVM;
    @Inject
    private WorkQueue workQueue;
    @Inject
    private SshDaemon daemon;
    @Inject
    @SitePath
    private File sitePath;
    @Option(name="--width", aliases={"-w"}, metaVar="COLS", usage="width of output table")
    private int columns = 80;
    private int nw;

    ShowCaches() {
    }

    @Override
    public void start(Environment env) throws IOException {
        String s = env.getEnv().get("COLUMNS");
        if (s != null && !s.isEmpty()) {
            try {
                this.columns = Integer.parseInt(s);
            }
            catch (NumberFormatException err) {
                this.columns = 80;
            }
        }
        super.start(env);
    }

    @Override
    protected void run() {
        this.nw = this.columns - 50;
        Date now = new Date();
        this.stdout.format("%-25s %-20s      now  %16s\n", "Gerrit Code Review", Version.getVersion() != null ? Version.getVersion() : "", new SimpleDateFormat("HH:mm:ss   zzz").format(now));
        this.stdout.format("%-25s %-20s   uptime %16s\n", "", "", this.uptime(now.getTime() - serverStarted));
        this.stdout.print('\n');
        this.stdout.print(String.format("%1s %-" + this.nw + "s|%-21s|  %-5s |%-9s|\n", "", "Name", "Entries", "AvgGet", "Hit Ratio"));
        this.stdout.print(String.format("%1s %-" + this.nw + "s|%6s %6s %7s|  %-5s  |%-4s %-4s|\n", "", "", "Mem", "Disk", "Space", "", "Mem", "Disk"));
        this.stdout.print("--");
        for (int i = 0; i < this.nw; ++i) {
            this.stdout.print('-');
        }
        this.stdout.print("+---------------------+---------+---------+\n");
        TreeMap<String, H2CacheImpl<?, ?>> disks = Maps.newTreeMap();
        this.printMemoryCaches(disks, this.sortedCoreCaches());
        this.printMemoryCaches(disks, this.sortedPluginCaches());
        for (Map.Entry entry : disks.entrySet()) {
            H2CacheImpl cache = (H2CacheImpl)entry.getValue();
            CacheStats stat = cache.stats();
            H2CacheImpl.DiskStats disk = cache.diskStats();
            this.stdout.print(String.format("D %-" + this.nw + "s|%6s %6s %7s| %7s |%4s %4s|\n", entry.getKey(), this.count(cache.size()), this.count(disk.size()), this.bytes(disk.space()), this.duration(stat.averageLoadPenalty()), this.percent(stat.hitCount(), stat.requestCount()), this.percent(disk.hitCount(), disk.requestCount())));
        }
        this.stdout.print('\n');
        if (this.gc) {
            System.gc();
            System.runFinalization();
            System.gc();
        }
        this.sshSummary();
        this.taskSummary();
        this.memSummary();
        if (this.showJVM) {
            this.jvmSummary();
        }
        this.stdout.flush();
    }

    private void printMemoryCaches(Map<String, H2CacheImpl<?, ?>> disks, Map<String, Cache<?, ?>> caches) {
        for (Map.Entry<String, Cache<?, ?>> entry : caches.entrySet()) {
            Cache<?, ?> cache = entry.getValue();
            if (cache instanceof H2CacheImpl) {
                disks.put(entry.getKey(), (H2CacheImpl)cache);
                continue;
            }
            CacheStats stat = cache.stats();
            this.stdout.print(String.format("  %-" + this.nw + "s|%6s %6s %7s| %7s |%4s %4s|\n", entry.getKey(), this.count(cache.size()), "", "", this.duration(stat.averageLoadPenalty()), this.percent(stat.hitCount(), stat.requestCount()), ""));
        }
    }

    private Map<String, Cache<?, ?>> sortedCoreCaches() {
        TreeMap<String, Cache<?, ?>> m = Maps.newTreeMap();
        for (Map.Entry entry : this.cacheMap.byPlugin("gerrit").entrySet()) {
            m.put(this.cacheNameOf("gerrit", entry.getKey()), (Cache<?, ?>)entry.getValue().get());
        }
        return m;
    }

    private Map<String, Cache<?, ?>> sortedPluginCaches() {
        TreeMap<String, Cache<?, ?>> m = Maps.newTreeMap();
        for (DynamicMap.Entry e : this.cacheMap) {
            if ("gerrit".equals(e.getPluginName())) continue;
            m.put(this.cacheNameOf(e.getPluginName(), e.getExportName()), (Cache<?, ?>)e.getProvider().get());
        }
        return m;
    }

    private void memSummary() {
        Runtime r = Runtime.getRuntime();
        long mMax = r.maxMemory();
        long mFree = r.freeMemory();
        long mTotal = r.totalMemory();
        long mInuse = mTotal - mFree;
        int jgitOpen = WindowCacheStatAccessor.getOpenFiles();
        long jgitBytes = WindowCacheStatAccessor.getOpenBytes();
        this.stdout.format("Mem: %s total = %s used + %s free + %s buffers\n", this.bytes(mTotal), this.bytes(mInuse - jgitBytes), this.bytes(mFree), this.bytes(jgitBytes));
        this.stdout.format("     %s max\n", this.bytes(mMax));
        this.stdout.format("    %8d open files, %8d cpus available, %8d threads\n", jgitOpen, r.availableProcessors(), ManagementFactory.getThreadMXBean().getThreadCount());
        this.stdout.print('\n');
    }

    private void taskSummary() {
        List<WorkQueue.Task<?>> pending = this.workQueue.getTasks();
        int tasksTotal = pending.size();
        int tasksRunning = 0;
        int tasksReady = 0;
        int tasksSleeping = 0;
        for (WorkQueue.Task task : pending) {
            switch (task.getState()) {
                case RUNNING: {
                    ++tasksRunning;
                    break;
                }
                case READY: {
                    ++tasksReady;
                    break;
                }
                case SLEEPING: {
                    ++tasksSleeping;
                    break;
                }
            }
        }
        this.stdout.format("Tasks: %4d  total = %4d running +   %4d ready + %4d sleeping\n", tasksTotal, tasksRunning, tasksReady, tasksSleeping);
    }

    private void sshSummary() {
        IoAcceptor acceptor = this.daemon.getIoAcceptor();
        if (acceptor == null) {
            return;
        }
        long now = TimeUtil.nowMs();
        Collection<IoSession> list = acceptor.getManagedSessions().values();
        long oldest = now;
        for (IoSession s : list) {
            if (!(s instanceof MinaSession)) continue;
            MinaSession minaSession = (MinaSession)s;
            oldest = Math.min(oldest, minaSession.getSession().getCreationTime());
        }
        this.stdout.format("SSH:   %4d  users, oldest session started %s ago\n", list.size(), this.uptime(now - oldest));
    }

    private void jvmSummary() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        this.stdout.format("JVM: %s %s %s\n", runtimeBean.getVmVendor(), runtimeBean.getVmName(), runtimeBean.getVmVersion());
        this.stdout.format("  on %s %s %s\n", osBean.getName(), osBean.getVersion(), osBean.getArch());
        try {
            this.stdout.format("  running as %s on %s\n", System.getProperty("user.name"), InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.stdout.format("  cwd  %s\n", this.path(new File(".").getAbsoluteFile().getParentFile()));
        this.stdout.format("  site %s\n", this.path(this.sitePath));
    }

    private String path(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException err) {
            return file.getAbsolutePath();
        }
    }

    private String uptime(long uptimeMillis) {
        if (uptimeMillis < 1000L) {
            return String.format("%3d ms", uptimeMillis);
        }
        long uptime = uptimeMillis / 1000L;
        long min = uptime / 60L;
        if (min < 60L) {
            return String.format("%2d min %2d sec", min, uptime - min * 60L);
        }
        long hr = uptime / 3600L;
        if (hr < 24L) {
            min = (uptime - hr * 3600L) / 60L;
            return String.format("%2d hrs %2d min", hr, min);
        }
        long days = uptime / 86400L;
        hr = (uptime - days * 24L * 3600L) / 3600L;
        return String.format("%4d days %2d hrs", days, hr);
    }

    private String bytes(double value) {
        value /= 1024.0;
        String suffix = "k";
        if (value > 1024.0) {
            value /= 1024.0;
            suffix = "m";
        }
        if (value > 1024.0) {
            value /= 1024.0;
            suffix = "g";
        }
        return String.format("%1$6.2f%2$s", value, suffix);
    }

    private String count(long cnt) {
        if (cnt == 0L) {
            return "";
        }
        return String.format("%6d", cnt);
    }

    private String duration(double ns) {
        if (ns < 0.5) {
            return "";
        }
        String suffix = "ns";
        if (ns >= 1000.0) {
            ns /= 1000.0;
            suffix = "us";
        }
        if (ns >= 1000.0) {
            ns /= 1000.0;
            suffix = "ms";
        }
        if (ns >= 1000.0) {
            ns /= 1000.0;
            suffix = "s ";
        }
        return String.format("%4.1f%s", ns, suffix);
    }

    private String percent(long value, long total) {
        if (total <= 0L) {
            return "";
        }
        long pcent = 100L * value / total;
        return String.format("%3d%%", (int)pcent);
    }

    static class StartupListener
    implements LifecycleListener {
        StartupListener() {
        }

        @Override
        public void start() {
            serverStarted = TimeUtil.nowMs();
        }

        @Override
        public void stop() {
        }
    }
}

