/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.QueryParseException;
import com.google.gwtorm.schema.QueryParser;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.sql.SqlBooleanTypeInfo;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class QueryModel {
    private final RelationModel model;
    private final String name;
    private final Tree parsedQuery;

    public QueryModel(RelationModel rel, String queryName, Query q) throws OrmException {
        this(rel, queryName, QueryModel.queryTextOf(queryName, q));
    }

    private static String queryTextOf(String queryName, Query q) throws OrmException {
        if (q == null) {
            throw new OrmException("Query " + queryName + " is missing " + Query.class.getName() + " annotation");
        }
        return q.value();
    }

    public QueryModel(RelationModel rel, String queryName, String queryText) throws OrmException {
        this.model = rel;
        this.name = queryName;
        try {
            this.parsedQuery = QueryParser.parse(this.model, queryText);
        }
        catch (QueryParseException e) {
            throw new OrmException("Cannot parse query " + queryText, e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Tree getParseTree() {
        return this.parsedQuery;
    }

    public List<ColumnModel> getParameters() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        if (this.parsedQuery != null) {
            this.findParameters(r, this.parsedQuery);
        }
        return r;
    }

    public List<OrderBy> getOrderBy() {
        Tree node;
        ArrayList<OrderBy> r = new ArrayList<OrderBy>();
        if (this.parsedQuery != null && (node = this.findOrderBy(this.parsedQuery)) != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Tree sortOrder = node.getChild(i);
                Tree id = sortOrder.getChild(0);
                r.add(new OrderBy(((QueryParser.Column)id).getField(), sortOrder.getType() == 17));
            }
        }
        return r;
    }

    private void findParameters(List<ColumnModel> r, Tree node) {
        switch (node.getType()) {
            case 4: {
                this.extractParameters(r, node);
                break;
            }
            default: {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.findParameters(r, node.getChild(i));
                }
            }
        }
    }

    private void extractParameters(List<ColumnModel> r, Tree node) {
        switch (node.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (node.getChild(1).getType() != 14) break;
                r.add(((QueryParser.Column)node.getChild(0)).getField());
                break;
            }
            default: {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.extractParameters(r, node.getChild(i));
                }
            }
        }
    }

    public boolean hasWhere() {
        return this.findWhere(this.parsedQuery) != null;
    }

    public boolean hasOrderBy() {
        return this.findOrderBy(this.parsedQuery) != null;
    }

    public boolean hasLimit() {
        return this.findLimit(this.parsedQuery) != null;
    }

    public boolean hasLimitParameter() {
        Tree limit = this.findLimit(this.parsedQuery);
        return limit != null && limit.getChild(0).getType() == 14;
    }

    public int getStaticLimit() {
        return Integer.parseInt(this.findLimit(this.parsedQuery).getChild(0).getText());
    }

    private Tree findWhere(Tree node) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 4: {
                return node;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree r = this.findLimit(node.getChild(i));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private Tree findLimit(Tree node) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 18: {
                return node;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree r = this.findLimit(node.getChild(i));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private Tree findOrderBy(Tree node) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 5: {
                return node;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree r = this.findOrderBy(node.getChild(i));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public String getSelectSql(SqlDialect dialect, String tableAlias) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.model.getSelectSql(dialect, tableAlias));
        if (this.parsedQuery != null) {
            FormatInfo fmt = new FormatInfo(buf, dialect, tableAlias);
            Tree t = this.expand(this.parsedQuery);
            if (t.getType() == 0) {
                this.formatChilden(fmt, t);
            } else {
                this.format(fmt, t);
            }
        }
        return buf.toString();
    }

    private void formatChilden(FormatInfo fmt, Tree node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.format(fmt, node.getChild(i));
        }
    }

    private void format(FormatInfo fmt, Tree node) {
        switch (node.getType()) {
            case 4: {
                fmt.buf.append(" WHERE ");
                this.formatChilden(fmt, node);
                break;
            }
            case 7: {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    if (i > 0) {
                        fmt.buf.append(" AND ");
                    }
                    this.format(fmt, node.getChild(i));
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.format(fmt, node.getChild(0));
                fmt.buf.append(node.getText());
                this.format(fmt, node.getChild(1));
                break;
            }
            case 13: {
                ColumnModel col = ((QueryParser.Column)node).getField();
                if (!col.isSqlPrimitive()) {
                    throw new IllegalStateException("Unexpanded nested field");
                }
                fmt.buf.append(fmt.tableAlias);
                fmt.buf.append('.');
                fmt.buf.append(col.getColumnName());
                break;
            }
            case 14: {
                fmt.buf.append(fmt.dialect.getParameterPlaceHolder(fmt.nthParam++));
                break;
            }
            case 21: {
                fmt.buf.append(((SqlBooleanTypeInfo)fmt.dialect.getSqlTypeInfo(Boolean.TYPE)).getTrueLiteralValue());
                break;
            }
            case 22: {
                fmt.buf.append(((SqlBooleanTypeInfo)fmt.dialect.getSqlTypeInfo(Boolean.TYPE)).getFalseLiteralValue());
                break;
            }
            case 19: 
            case 20: {
                fmt.buf.append(node.getText());
                break;
            }
            case 5: {
                fmt.buf.append(" ORDER BY ");
                for (int i = 0; i < node.getChildCount(); ++i) {
                    ColumnModel col;
                    Tree sortOrder = node.getChild(i);
                    Tree id = sortOrder.getChild(0);
                    if (i > 0) {
                        fmt.buf.append(',');
                    }
                    if ((col = ((QueryParser.Column)id).getField()).isNested()) {
                        Iterator<ColumnModel> cItr = col.getAllLeafColumns().iterator();
                        while (cItr.hasNext()) {
                            fmt.buf.append(fmt.tableAlias);
                            fmt.buf.append('.');
                            fmt.buf.append(cItr.next().getColumnName());
                            if (sortOrder.getType() == 17) {
                                fmt.buf.append(" DESC");
                            }
                            if (!cItr.hasNext()) continue;
                            fmt.buf.append(',');
                        }
                        continue;
                    }
                    fmt.buf.append(fmt.tableAlias);
                    fmt.buf.append('.');
                    fmt.buf.append(col.getColumnName());
                    if (sortOrder.getType() != 17) continue;
                    fmt.buf.append(" DESC");
                }
                break;
            }
            case 18: {
                Tree p;
                if (!fmt.dialect.selectHasLimit() || (p = node.getChild(0)).getType() != 19) break;
                fmt.buf.append(" LIMIT ");
                fmt.buf.append(p.getText());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported query token");
            }
        }
    }

    public String toString() {
        return "Query[" + this.name + " " + this.getParseTree().toStringTree() + "]";
    }

    private Tree expand(Tree node) {
        switch (node.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                QueryParser.Column qpc = (QueryParser.Column)node.getChild(0);
                ColumnModel f = qpc.getField();
                if (!f.isNested()) break;
                CommonTree join = new CommonTree(new CommonToken(7));
                for (ColumnModel c : f.getAllLeafColumns()) {
                    Tree op = node.dupNode();
                    op.addChild(new QueryParser.Column(qpc, c));
                    op.addChild(node.getChild(1).dupNode());
                    join.addChild(op);
                }
                return join;
            }
        }
        Tree r = node.dupNode();
        for (int i = 0; i < node.getChildCount(); ++i) {
            r.addChild(this.expand(node.getChild(i)));
        }
        return r;
    }

    static class FormatInfo {
        final StringBuilder buf;
        final SqlDialect dialect;
        final String tableAlias;
        int nthParam = 1;

        FormatInfo(StringBuilder r, SqlDialect dialect, String tableAlias) {
            this.buf = r;
            this.dialect = dialect;
            this.tableAlias = tableAlias;
        }
    }

    public static class OrderBy {
        public final ColumnModel column;
        public final boolean descending;

        public OrderBy(ColumnModel column, boolean desc) {
            this.column = column;
            this.descending = desc;
        }

        public int hashCode() {
            return this.column.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof OrderBy) {
                OrderBy o = (OrderBy)other;
                return this.column.equals(o.column) && this.descending == o.descending;
            }
            return false;
        }
    }
}

