/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScpHelper {
    protected static final Logger log = LoggerFactory.getLogger(ScpHelper.class);
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    protected final FileSystemView root;
    protected final InputStream in;
    protected final OutputStream out;

    public ScpHelper(InputStream in, OutputStream out, FileSystemView root) {
        this.in = in;
        this.out = out;
        this.root = root;
    }

    public void receive(SshFile path, boolean recursive, boolean shouldBeDir, boolean preserve) throws IOException {
        if (shouldBeDir) {
            if (!path.doesExist()) {
                throw new SshException("Target directory " + path.toString() + " does not exists");
            }
            if (!path.isDirectory()) {
                throw new SshException("Target directory " + path.toString() + " is not a directory");
            }
        }
        this.ack();
        long[] time = null;
        block7: while (true) {
            String line;
            boolean isDir = false;
            int c = this.readAck(true);
            switch (c) {
                case -1: {
                    return;
                }
                case 68: {
                    isDir = true;
                }
                case 67: {
                    line = (char)c + this.readLine();
                    log.debug("Received header: " + line);
                    break;
                }
                case 84: {
                    line = (char)c + this.readLine();
                    log.debug("Received header: " + line);
                    time = this.parseTime(line);
                    this.ack();
                    continue block7;
                }
                case 69: {
                    line = (char)c + this.readLine();
                    log.debug("Received header: " + line);
                    return;
                }
                default: {
                    continue block7;
                }
            }
            if (recursive && isDir) {
                this.receiveDir(line, path, time, preserve);
                time = null;
                continue;
            }
            this.receiveFile(line, path, time, preserve);
            time = null;
        }
    }

    public void receiveDir(String header, SshFile path, long[] time, boolean preserve) throws IOException {
        block13: {
            SshFile file;
            if (log.isDebugEnabled()) {
                log.debug("Receiving directory {}", path);
            }
            if (!header.startsWith("D")) {
                throw new IOException("Expected a D message but got '" + header + "'");
            }
            String perms = header.substring(1, 5);
            int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
            String name = header.substring(header.indexOf(32, 6) + 1);
            if (length != 0) {
                throw new IOException("Expected 0 length for directory but got " + length);
            }
            if (path.doesExist() && path.isDirectory()) {
                file = this.root.getFile(path, name);
            } else if (!path.doesExist() && path.getParentFile().doesExist() && path.getParentFile().isDirectory()) {
                file = path;
            } else {
                throw new IOException("Can not write to " + path);
            }
            if (!(file.doesExist() && file.isDirectory() || file.mkdir())) {
                throw new IOException("Could not create directory " + file);
            }
            if (preserve) {
                HashMap<SshFile.Attribute, Object> attrs = new HashMap<SshFile.Attribute, Object>();
                attrs.put(SshFile.Attribute.Permissions, ScpHelper.fromOctalPerms(perms));
                if (time != null) {
                    attrs.put(SshFile.Attribute.LastModifiedTime, time[0]);
                    attrs.put(SshFile.Attribute.LastAccessTime, time[1]);
                }
                file.setAttributes(attrs);
            }
            this.ack();
            time = null;
            while (true) {
                header = this.readLine();
                log.debug("Received header: " + header);
                if (header.startsWith("C")) {
                    this.receiveFile(header, file, time, preserve);
                    time = null;
                    continue;
                }
                if (header.startsWith("D")) {
                    this.receiveDir(header, file, time, preserve);
                    time = null;
                    continue;
                }
                if (header.equals("E")) break block13;
                if (!header.startsWith("T")) break;
                time = this.parseTime(header);
                this.ack();
            }
            throw new IOException("Unexpected message: '" + header + "'");
        }
        this.ack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFile(String header, SshFile path, long[] time, boolean preserve) throws IOException {
        SshFile file;
        if (log.isDebugEnabled()) {
            log.debug("Receiving file {}", path);
        }
        if (!header.startsWith("C")) {
            throw new IOException("Expected a C message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        long length = Long.parseLong(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (path.doesExist() && path.isDirectory()) {
            file = this.root.getFile(path, name);
        } else if (path.doesExist() && path.isFile()) {
            file = path;
        } else if (!path.doesExist() && path.getParentFile().doesExist() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (file.doesExist() && file.isDirectory()) {
            throw new IOException("File is a directory: " + file);
        }
        if (file.doesExist() && !file.isWritable()) {
            throw new IOException("Can not write to file: " + file);
        }
        OutputStream os = file.createOutputStream(0L);
        try {
            this.ack();
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int len = (int)Math.min(length, (long)buffer.length);
                if ((len = this.in.read(buffer, 0, len)) <= 0) {
                    throw new IOException("End of stream reached");
                }
                os.write(buffer, 0, len);
                length -= (long)len;
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            os.close();
            throw throwable;
        }
        os.close();
        if (preserve) {
            HashMap<SshFile.Attribute, Object> attrs = new HashMap<SshFile.Attribute, Object>();
            attrs.put(SshFile.Attribute.Permissions, ScpHelper.fromOctalPerms(perms));
            if (time != null) {
                attrs.put(SshFile.Attribute.LastModifiedTime, time[0]);
                attrs.put(SshFile.Attribute.LastAccessTime, time[1]);
            }
            file.setAttributes(attrs);
        }
        this.ack();
        this.readAck(false);
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean canEof) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                if (!canEof) {
                    throw new EOFException();
                }
                return null;
            }
            baos.write(c);
        }
        return baos.toString();
    }

    public void send(List<String> paths, boolean recursive, boolean preserve) throws IOException {
        for (String pattern : paths) {
            SshFile file;
            int lastSep;
            String basedir;
            int idx = pattern.indexOf(42);
            if (idx >= 0) {
                String[] included;
                basedir = "";
                lastSep = pattern.substring(0, idx).lastIndexOf(47);
                if (lastSep >= 0) {
                    basedir = pattern.substring(0, lastSep);
                    pattern = pattern.substring(lastSep + 1);
                }
                for (String path : included = new DirectoryScanner(basedir, pattern).scan()) {
                    SshFile file2 = this.root.getFile(basedir + "/" + path);
                    if (file2.isFile()) {
                        this.sendFile(file2, preserve);
                        continue;
                    }
                    if (file2.isDirectory()) {
                        if (!recursive) {
                            this.out.write(1);
                            this.out.write((path + " not a regular file\n").getBytes());
                            continue;
                        }
                        this.sendDir(file2, preserve);
                        continue;
                    }
                    this.out.write(1);
                    this.out.write((path + " unknown file type\n").getBytes());
                }
                continue;
            }
            basedir = "";
            lastSep = pattern.lastIndexOf(47);
            if (lastSep >= 0) {
                basedir = pattern.substring(0, lastSep);
                pattern = pattern.substring(lastSep + 1);
            }
            if (!(file = this.root.getFile(basedir + "/" + pattern)).doesExist()) {
                throw new IOException(file + ": no such file or directory");
            }
            if (file.isFile()) {
                this.sendFile(file, preserve);
                continue;
            }
            if (file.isDirectory()) {
                if (!recursive) {
                    throw new IOException(file + " not a regular file");
                }
                this.sendDir(file, preserve);
                continue;
            }
            throw new IOException(file + ": unknown file type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(SshFile path, boolean preserve) throws IOException {
        StringBuffer buf;
        if (log.isDebugEnabled()) {
            log.debug("Sending file {}", path);
        }
        Map<SshFile.Attribute, Object> attrs = path.getAttributes(true);
        if (preserve) {
            buf = new StringBuffer();
            buf.append("T");
            buf.append(attrs.get((Object)SshFile.Attribute.LastModifiedTime));
            buf.append(" ");
            buf.append("0");
            buf.append(" ");
            buf.append(attrs.get((Object)SshFile.Attribute.LastAccessTime));
            buf.append(" ");
            buf.append("0");
            buf.append("\n");
            this.out.write(buf.toString().getBytes());
            this.out.flush();
            this.readAck(false);
        }
        buf = new StringBuffer();
        buf.append("C");
        buf.append(preserve ? ScpHelper.toOctalPerms((EnumSet)attrs.get((Object)SshFile.Attribute.Permissions)) : "0644");
        buf.append(" ");
        buf.append(attrs.get((Object)SshFile.Attribute.Size));
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        InputStream is = path.createInputStream(0L);
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                this.out.write(buffer, 0, len);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            is.close();
            throw throwable;
        }
        is.close();
        this.ack();
        this.readAck(false);
    }

    public void sendDir(SshFile path, boolean preserve) throws IOException {
        StringBuffer buf;
        if (log.isDebugEnabled()) {
            log.debug("Sending directory {}", path);
        }
        Map<SshFile.Attribute, Object> attrs = path.getAttributes(true);
        if (preserve) {
            buf = new StringBuffer();
            buf.append("T");
            buf.append(attrs.get((Object)SshFile.Attribute.LastModifiedTime));
            buf.append(" ");
            buf.append("0");
            buf.append(" ");
            buf.append(attrs.get((Object)SshFile.Attribute.LastAccessTime));
            buf.append(" ");
            buf.append("0");
            buf.append("\n");
            this.out.write(buf.toString().getBytes());
            this.out.flush();
            this.readAck(false);
        }
        buf = new StringBuffer();
        buf.append("D");
        buf.append(preserve ? ScpHelper.toOctalPerms((EnumSet)attrs.get((Object)SshFile.Attribute.Permissions)) : "0755");
        buf.append(" ");
        buf.append("0");
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        for (SshFile child : path.listSshFiles()) {
            if (child.isFile()) {
                this.sendFile(child, preserve);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.sendDir(child, preserve);
        }
        this.out.write("E\n".getBytes());
        this.out.flush();
        this.readAck(false);
    }

    private long[] parseTime(String line) {
        String[] numbers = line.substring(1).split(" ");
        return new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[2])};
    }

    public static String toOctalPerms(EnumSet<SshFile.Permission> perms) {
        int pf = 0;
        for (SshFile.Permission p : perms) {
            switch (p) {
                case UserRead: {
                    pf |= 0x100;
                    break;
                }
                case UserWrite: {
                    pf |= 0x80;
                    break;
                }
                case UserExecute: {
                    pf |= 0x40;
                    break;
                }
                case GroupRead: {
                    pf |= 0x20;
                    break;
                }
                case GroupWrite: {
                    pf |= 0x10;
                    break;
                }
                case GroupExecute: {
                    pf |= 8;
                    break;
                }
                case OthersRead: {
                    pf |= 4;
                    break;
                }
                case OthersWrite: {
                    pf |= 2;
                    break;
                }
                case OthersExecute: {
                    pf |= 1;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static EnumSet<SshFile.Permission> fromOctalPerms(String str) {
        int perms = Integer.parseInt(str, 8);
        EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
        if ((perms & 0x100) != 0) {
            p.add(SshFile.Permission.UserRead);
        }
        if ((perms & 0x80) != 0) {
            p.add(SshFile.Permission.UserWrite);
        }
        if ((perms & 0x40) != 0) {
            p.add(SshFile.Permission.UserExecute);
        }
        if ((perms & 0x20) != 0) {
            p.add(SshFile.Permission.GroupRead);
        }
        if ((perms & 0x10) != 0) {
            p.add(SshFile.Permission.GroupWrite);
        }
        if ((perms & 8) != 0) {
            p.add(SshFile.Permission.GroupExecute);
        }
        if ((perms & 4) != 0) {
            p.add(SshFile.Permission.OthersRead);
        }
        if ((perms & 2) != 0) {
            p.add(SshFile.Permission.OthersWrite);
        }
        if ((perms & 1) != 0) {
            p.add(SshFile.Permission.OthersExecute);
        }
        return p;
    }

    public void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    public int readAck(boolean canEof) throws IOException {
        int c = this.in.read();
        switch (c) {
            case -1: {
                if (canEof) break;
                throw new EOFException();
            }
            case 0: {
                break;
            }
            case 1: {
                log.warn("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
        return c;
    }
}

