/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.PermissionRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Permission
implements Comparable<Permission> {
    public static final String ABANDON = "abandon";
    public static final String CREATE = "create";
    public static final String DELETE_DRAFTS = "deleteDrafts";
    public static final String EDIT_TOPIC_NAME = "editTopicName";
    public static final String FORGE_AUTHOR = "forgeAuthor";
    public static final String FORGE_COMMITTER = "forgeCommitter";
    public static final String FORGE_SERVER = "forgeServerAsCommitter";
    public static final String LABEL = "label-";
    public static final String LABEL_AS = "labelAs-";
    public static final String OWNER = "owner";
    public static final String PUBLISH_DRAFTS = "publishDrafts";
    public static final String PUSH = "push";
    public static final String PUSH_MERGE = "pushMerge";
    public static final String PUSH_TAG = "pushTag";
    public static final String PUSH_SIGNED_TAG = "pushSignedTag";
    public static final String READ = "read";
    public static final String REBASE = "rebase";
    public static final String REMOVE_REVIEWER = "removeReviewer";
    public static final String SUBMIT = "submit";
    public static final String SUBMIT_AS = "submitAs";
    public static final String VIEW_DRAFTS = "viewDrafts";
    private static final List<String> NAMES_LC = new ArrayList<String>();
    private static final int labelIndex;
    private static final int labelAsIndex;
    protected String name;
    protected boolean exclusiveGroup;
    protected List<PermissionRule> rules;

    public static boolean isPermission(String varName) {
        return Permission.isLabel(varName) || Permission.isLabelAs(varName) || NAMES_LC.contains(varName.toLowerCase());
    }

    public static boolean hasRange(String varName) {
        return Permission.isLabel(varName) || Permission.isLabelAs(varName);
    }

    public static boolean isLabel(String varName) {
        return varName.startsWith(LABEL) && LABEL.length() < varName.length();
    }

    public static boolean isLabelAs(String var) {
        return var.startsWith(LABEL_AS) && LABEL_AS.length() < var.length();
    }

    public static String forLabel(String labelName) {
        return LABEL + labelName;
    }

    public static String forLabelAs(String labelName) {
        return LABEL_AS + labelName;
    }

    public static String extractLabel(String varName) {
        if (Permission.isLabel(varName)) {
            return varName.substring(LABEL.length());
        }
        if (Permission.isLabelAs(varName)) {
            return varName.substring(LABEL_AS.length());
        }
        return null;
    }

    public static boolean canBeOnAllProjects(String ref, String permissionName) {
        if ("refs/*".equals(ref)) {
            return !OWNER.equals(permissionName);
        }
        return true;
    }

    protected Permission() {
    }

    public Permission(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return Permission.extractLabel(this.getName());
    }

    public Boolean getExclusiveGroup() {
        return this.exclusiveGroup && !OWNER.equals(this.getName());
    }

    public void setExclusiveGroup(Boolean newExclusiveGroup) {
        this.exclusiveGroup = newExclusiveGroup;
    }

    public List<PermissionRule> getRules() {
        this.initRules();
        return this.rules;
    }

    public void setRules(List<PermissionRule> list) {
        this.rules = list;
    }

    public void add(PermissionRule rule) {
        this.initRules();
        this.rules.add(rule);
    }

    public void remove(PermissionRule rule) {
        if (rule != null) {
            this.removeRule(rule.getGroup());
        }
    }

    public void removeRule(GroupReference group) {
        if (this.rules != null) {
            Iterator<PermissionRule> itr = this.rules.iterator();
            while (itr.hasNext()) {
                if (!Permission.sameGroup(itr.next(), group)) continue;
                itr.remove();
            }
        }
    }

    public PermissionRule getRule(GroupReference group) {
        return this.getRule(group, false);
    }

    public PermissionRule getRule(GroupReference group, boolean create) {
        this.initRules();
        for (PermissionRule r : this.rules) {
            if (!Permission.sameGroup(r, group)) continue;
            return r;
        }
        if (create) {
            PermissionRule r = new PermissionRule(group);
            this.rules.add(r);
            return r;
        }
        return null;
    }

    void mergeFrom(Permission src) {
        for (PermissionRule srcRule : src.getRules()) {
            PermissionRule dstRule = this.getRule(srcRule.getGroup());
            if (dstRule != null) {
                dstRule.mergeFrom(srcRule);
                continue;
            }
            this.add(srcRule);
        }
    }

    private static boolean sameGroup(PermissionRule rule, GroupReference group) {
        if (group.getUUID() != null) {
            return group.getUUID().equals(rule.getGroup().getUUID());
        }
        if (group.getName() != null) {
            return group.getName().equals(rule.getGroup().getName());
        }
        return false;
    }

    private void initRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<PermissionRule>(4);
        }
    }

    @Override
    public int compareTo(Permission b) {
        int cmp = Permission.index(this) - Permission.index(b);
        if (cmp == 0) {
            cmp = this.getName().compareTo(b.getName());
        }
        return cmp;
    }

    private static int index(Permission a) {
        if (Permission.isLabel(a.getName())) {
            return labelIndex;
        }
        if (Permission.isLabelAs(a.getName())) {
            return labelAsIndex;
        }
        int index = NAMES_LC.indexOf(a.getName().toLowerCase());
        return 0 <= index ? index : NAMES_LC.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (!this.name.equals(other.name) || this.exclusiveGroup != other.exclusiveGroup) {
            return false;
        }
        return new HashSet<PermissionRule>(this.getRules()).equals(new HashSet<PermissionRule>(other.getRules()));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.name).append(" ");
        if (this.exclusiveGroup) {
            bldr.append("[exclusive] ");
        }
        bldr.append("[");
        Iterator<PermissionRule> it = this.getRules().iterator();
        while (it.hasNext()) {
            bldr.append(it.next());
            if (!it.hasNext()) continue;
            bldr.append(", ");
        }
        bldr.append("]");
        return bldr.toString();
    }

    static {
        NAMES_LC.add(OWNER.toLowerCase());
        NAMES_LC.add(READ.toLowerCase());
        NAMES_LC.add(ABANDON.toLowerCase());
        NAMES_LC.add(CREATE.toLowerCase());
        NAMES_LC.add(FORGE_AUTHOR.toLowerCase());
        NAMES_LC.add(FORGE_COMMITTER.toLowerCase());
        NAMES_LC.add(FORGE_SERVER.toLowerCase());
        NAMES_LC.add(PUSH.toLowerCase());
        NAMES_LC.add(PUSH_MERGE.toLowerCase());
        NAMES_LC.add(PUSH_TAG.toLowerCase());
        NAMES_LC.add(PUSH_SIGNED_TAG.toLowerCase());
        NAMES_LC.add(LABEL.toLowerCase());
        NAMES_LC.add(LABEL_AS.toLowerCase());
        NAMES_LC.add(REBASE.toLowerCase());
        NAMES_LC.add(REMOVE_REVIEWER.toLowerCase());
        NAMES_LC.add(SUBMIT.toLowerCase());
        NAMES_LC.add(SUBMIT_AS.toLowerCase());
        NAMES_LC.add(VIEW_DRAFTS.toLowerCase());
        NAMES_LC.add(EDIT_TOPIC_NAME.toLowerCase());
        NAMES_LC.add(DELETE_DRAFTS.toLowerCase());
        NAMES_LC.add(PUBLISH_DRAFTS.toLowerCase());
        labelIndex = NAMES_LC.indexOf(LABEL);
        labelAsIndex = NAMES_LC.indexOf(LABEL_AS.toLowerCase());
    }
}

