/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.StringKey;

public final class AccountGroup {
    @Column(id=1)
    protected NameKey name;
    @Column(id=2)
    protected Id groupId;
    @Column(id=4, length=0x7FFFFFFF, notNull=false)
    protected String description;
    @Column(id=7)
    protected boolean visibleToAll;
    @Column(id=9)
    protected UUID groupUUID;
    @Column(id=10)
    protected UUID ownerGroupUUID;

    public static boolean isInternalGroup(UUID uuid) {
        return uuid.get().matches("^[0-9a-f]{40}$");
    }

    protected AccountGroup() {
    }

    public AccountGroup(NameKey newName, Id newId, UUID uuid) {
        this.name = newName;
        this.groupId = newId;
        this.visibleToAll = false;
        this.ownerGroupUUID = this.groupUUID = uuid;
    }

    public Id getId() {
        return this.groupId;
    }

    public String getName() {
        return this.name.get();
    }

    public NameKey getNameKey() {
        return this.name;
    }

    public void setNameKey(NameKey nameKey) {
        this.name = nameKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public UUID getOwnerGroupUUID() {
        return this.ownerGroupUUID;
    }

    public void setOwnerGroupUUID(UUID uuid) {
        this.ownerGroupUUID = uuid;
    }

    public void setVisibleToAll(boolean visibleToAll) {
        this.visibleToAll = visibleToAll;
    }

    public boolean isVisibleToAll() {
        return this.visibleToAll;
    }

    public UUID getGroupUUID() {
        return this.groupUUID;
    }

    public void setGroupUUID(UUID uuid) {
        this.groupUUID = uuid;
    }

    public static class Id
    extends IntKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        @Override
        public int get() {
            return this.id;
        }

        @Override
        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }
    }

    public static class UUID
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String uuid;

        protected UUID() {
        }

        public UUID(String n) {
            this.uuid = n;
        }

        @Override
        public String get() {
            return this.uuid;
        }

        @Override
        protected void set(String newValue) {
            this.uuid = newValue;
        }

        public static UUID parse(String str) {
            UUID r = new UUID();
            r.fromString(str);
            return r;
        }
    }

    public static class NameKey
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String name;

        protected NameKey() {
        }

        public NameKey(String n) {
            this.name = n;
        }

        @Override
        public String get() {
            return this.name;
        }

        @Override
        protected void set(String newValue) {
            this.name = newValue;
        }
    }
}

