/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;

public final class AccountGroupByIdAud {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Account.Id addedBy;
    @Column(id=3, notNull=false)
    protected Account.Id removedBy;
    @Column(id=4, notNull=false)
    protected Timestamp removedOn;

    protected AccountGroupByIdAud() {
    }

    public AccountGroupByIdAud(AccountGroupById m, Account.Id adder, Timestamp when) {
        AccountGroup.Id group = m.getGroupId();
        AccountGroup.UUID include = m.getIncludeUUID();
        this.key = new Key(group, include, when);
        this.addedBy = adder;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isActive() {
        return this.removedOn == null;
    }

    public void removed(Account.Id deleter, Timestamp when) {
        this.removedBy = deleter;
        this.removedOn = when;
    }

    public static class Key
    extends CompoundKey<AccountGroup.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected AccountGroup.Id groupId;
        @Column(id=2)
        protected AccountGroup.UUID includeUUID;
        @Column(id=3)
        protected Timestamp addedOn;

        protected Key() {
            this.groupId = new AccountGroup.Id();
            this.includeUUID = new AccountGroup.UUID();
        }

        public Key(AccountGroup.Id g, AccountGroup.UUID u, Timestamp t) {
            this.groupId = g;
            this.includeUUID = u;
            this.addedOn = t;
        }

        @Override
        public AccountGroup.Id getParentKey() {
            return this.groupId;
        }

        public AccountGroup.UUID getIncludeUUID() {
            return this.includeUUID;
        }

        public Timestamp getAddedOn() {
            return this.addedOn;
        }

        @Override
        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.includeUUID};
        }
    }
}

