/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.RowVersion;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;

public final class Change {
    private static final char MIN_OPEN = 'a';
    public static final char STATUS_NEW = 'n';
    public static final char STATUS_SUBMITTED = 's';
    public static final char STATUS_DRAFT = 'd';
    private static final char MAX_OPEN = 'z';
    public static final char STATUS_MERGED = 'M';
    public static final int INITIAL_PATCH_SET_ID = 1;
    @Column(id=1)
    protected Id changeId;
    @Column(id=2)
    protected Key changeKey;
    @Column(id=3)
    @RowVersion
    protected int rowVersion;
    @Column(id=4)
    protected Timestamp createdOn;
    @Column(id=5)
    protected Timestamp lastUpdatedOn;
    @Column(id=6, length=16)
    protected String sortKey;
    @Column(id=7, name="owner_account_id")
    protected Account.Id owner;
    @Column(id=8)
    protected Branch.NameKey dest;
    @Column(id=9)
    protected boolean open;
    @Column(id=10)
    protected char status;
    @Column(id=12)
    protected int currentPatchSetId;
    @Column(id=13)
    protected String subject;
    @Column(id=14, notNull=false)
    protected String topic;
    @Column(id=15, notNull=false)
    protected RevId lastSha1MergeTested;
    @Column(id=16)
    protected boolean mergeable;

    protected Change() {
    }

    public Change(Key newKey, Id newId, Account.Id ownedBy, Branch.NameKey forBranch, Timestamp ts) {
        this.changeKey = newKey;
        this.changeId = newId;
        this.lastUpdatedOn = this.createdOn = ts;
        this.owner = ownedBy;
        this.dest = forBranch;
        this.setStatus(Status.NEW);
        this.setLastSha1MergeTested(null);
    }

    public Change(Change other) {
        this.changeId = other.changeId;
        this.changeKey = other.changeKey;
        this.rowVersion = other.rowVersion;
        this.createdOn = other.createdOn;
        this.lastUpdatedOn = other.lastUpdatedOn;
        this.sortKey = other.sortKey;
        this.owner = other.owner;
        this.dest = other.dest;
        this.open = other.open;
        this.status = other.status;
        this.currentPatchSetId = other.currentPatchSetId;
        this.subject = other.subject;
        this.topic = other.topic;
        this.mergeable = other.mergeable;
    }

    public Id getId() {
        return this.changeId;
    }

    public int getChangeId() {
        return this.changeId.get();
    }

    public Key getKey() {
        return this.changeKey;
    }

    public void setKey(Key k) {
        this.changeKey = k;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public Timestamp getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Timestamp now) {
        this.lastUpdatedOn = now;
    }

    public int getRowVersion() {
        return this.rowVersion;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String newSortKey) {
        this.sortKey = newSortKey;
    }

    public Account.Id getOwner() {
        return this.owner;
    }

    public Branch.NameKey getDest() {
        return this.dest;
    }

    public Project.NameKey getProject() {
        return this.dest.getParentKey();
    }

    public String getSubject() {
        return this.subject;
    }

    public PatchSet.Id currentPatchSetId() {
        if (this.currentPatchSetId > 0) {
            return new PatchSet.Id(this.changeId, this.currentPatchSetId);
        }
        return null;
    }

    public void setCurrentPatchSet(PatchSetInfo ps) {
        this.currentPatchSetId = ps.getKey().get();
        this.subject = ps.getSubject();
    }

    public Status getStatus() {
        return Status.forCode(this.status);
    }

    public void setStatus(Status newStatus) {
        this.open = newStatus.isOpen();
        this.status = newStatus.getCode();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public RevId getLastSha1MergeTested() {
        return this.lastSha1MergeTested;
    }

    public void setLastSha1MergeTested(RevId lastSha1MergeTested) {
        this.lastSha1MergeTested = lastSha1MergeTested;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public static enum Status {
        NEW('n'),
        SUBMITTED('s'),
        DRAFT('d'),
        MERGED('M'),
        ABANDONED('A');

        private final char code;
        private final boolean closed;

        private Status(char c) {
            this.code = c;
            this.closed = 'a' > c || c > 'z';
        }

        public char getCode() {
            return this.code;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }

    public static class Key
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=60)
        protected String id;

        protected Key() {
        }

        public Key(String id) {
            this.id = id;
        }

        @Override
        public String get() {
            return this.id;
        }

        @Override
        protected void set(String newValue) {
            this.id = newValue;
        }

        public Key max() {
            StringBuilder revEnd = new StringBuilder(this.get().length() + 1);
            revEnd.append(this.get());
            revEnd.append('\u9fa5');
            return new Key(revEnd.toString());
        }

        public String abbreviate() {
            String s = this.get();
            return s.substring(0, Math.min(s.length(), 9));
        }

        public static Key parse(String str) {
            Key r = new Key();
            r.fromString(str);
            return r;
        }
    }

    public static class Id
    extends IntKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        @Override
        public int get() {
            return this.id;
        }

        @Override
        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String ref) {
            return PatchSet.Id.fromRef(ref).getParentKey();
        }
    }
}

