/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

class GetArchive
implements RestReadView<RevisionResource> {
    private static final Map<String, ArchiveFormat> formats = ArchiveFormat.init();
    private final GitRepositoryManager repoManager;
    @Option(name="--format")
    private String format;

    @Inject
    GetArchive(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryResult apply(RevisionResource rsrc) throws BadRequestException, IOException {
        if (Strings.isNullOrEmpty(this.format)) {
            throw new BadRequestException("format is not specified");
        }
        final ArchiveFormat f = formats.get("." + this.format);
        if (f == null) {
            throw new BadRequestException("unknown archive format");
        }
        boolean close = true;
        final Repository repo = this.repoManager.openRepository(rsrc.getControl().getProject().getNameKey());
        try {
            final RevWalk rw = new RevWalk(repo);
            try {
                final RevCommit commit = rw.parseCommit(ObjectId.fromString(rsrc.getPatchSet().getRevision().get()));
                BinaryResult bin = new BinaryResult(){

                    @Override
                    public void writeTo(OutputStream out) throws IOException {
                        try {
                            new ArchiveCommand(repo).setFormat(f.name()).setTree(commit.getTree()).setOutputStream(out).call();
                        }
                        catch (GitAPIException e) {
                            throw new IOException(e);
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        rw.release();
                        repo.close();
                    }
                };
                bin.disableGzip().setContentType(f.getMimeType()).setAttachmentName(GetArchive.name(f, rw, commit));
                close = false;
                BinaryResult binaryResult = bin;
                if (close) {
                    rw.release();
                }
                return binaryResult;
            }
            catch (Throwable throwable) {
                if (close) {
                    rw.release();
                }
                throw throwable;
            }
        }
        finally {
            if (close) {
                repo.close();
            }
        }
    }

    private static String name(ArchiveFormat format, RevWalk rw, RevCommit commit) throws IOException {
        return String.format("%s%s", rw.getObjectReader().abbreviate(commit, 7).name(), format.getDefaultSuffix());
    }
}

