/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Maps;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedHashMap;
import java.util.List;

class ListReviewers
implements RestReadView<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final ReviewerJson json;
    private final ReviewerResource.Factory resourceFactory;

    @Inject
    ListReviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, ReviewerResource.Factory resourceFactory, ReviewerJson json) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.resourceFactory = resourceFactory;
        this.json = json;
    }

    public List<ReviewerJson.ReviewerInfo> apply(ChangeResource rsrc) throws OrmException {
        LinkedHashMap<Account.Id, ReviewerResource> reviewers = Maps.newLinkedHashMap();
        ReviewDb db = this.dbProvider.get();
        for (Account.Id accountId : this.approvalsUtil.getReviewers(db, rsrc.getNotes()).values()) {
            if (reviewers.containsKey(accountId)) continue;
            reviewers.put(accountId, this.resourceFactory.create(rsrc, accountId));
        }
        return this.json.format(reviewers.values());
    }
}

