/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.ChangeMessages;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.mail.AddReviewerSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostReviewers
implements RestModifyView<ChangeResource, AddReviewerInput> {
    private static final Logger log = LoggerFactory.getLogger(PostReviewers.class);
    public static final int DEFAULT_MAX_REVIEWERS_WITHOUT_CHECK = 10;
    public static final int DEFAULT_MAX_REVIEWERS = 20;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory reviewerFactory;
    private final ApprovalsUtil approvalsUtil;
    private final AddReviewerSender.Factory addReviewerSenderFactory;
    private final Provider<GroupsCollection> groupsCollection;
    private final GroupMembers.Factory groupMembersFactory;
    private final AccountInfo.Loader.Factory accountLoaderFactory;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeUpdate.Factory updateFactory;
    private final IdentifiedUser currentUser;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Config cfg;
    private final ChangeHooks hooks;
    private final AccountCache accountCache;
    private final ReviewerJson json;
    private final ChangeIndexer indexer;

    @Inject
    PostReviewers(AccountsCollection accounts, ReviewerResource.Factory reviewerFactory, ApprovalsUtil approvalsUtil, AddReviewerSender.Factory addReviewerSenderFactory, Provider<GroupsCollection> groupsCollection, GroupMembers.Factory groupMembersFactory, AccountInfo.Loader.Factory accountLoaderFactory, Provider<ReviewDb> db, ChangeUpdate.Factory updateFactory, IdentifiedUser currentUser, IdentifiedUser.GenericFactory identifiedUserFactory, @GerritServerConfig Config cfg, ChangeHooks hooks, AccountCache accountCache, ReviewerJson json, ChangeIndexer indexer) {
        this.accounts = accounts;
        this.reviewerFactory = reviewerFactory;
        this.approvalsUtil = approvalsUtil;
        this.addReviewerSenderFactory = addReviewerSenderFactory;
        this.groupsCollection = groupsCollection;
        this.groupMembersFactory = groupMembersFactory;
        this.accountLoaderFactory = accountLoaderFactory;
        this.dbProvider = db;
        this.updateFactory = updateFactory;
        this.currentUser = currentUser;
        this.identifiedUserFactory = identifiedUserFactory;
        this.cfg = cfg;
        this.hooks = hooks;
        this.accountCache = accountCache;
        this.json = json;
        this.indexer = indexer;
    }

    public ReviewerJson.PostResult apply(ChangeResource rsrc, AddReviewerInput input) throws AuthException, BadRequestException, UnprocessableEntityException, OrmException, EmailException, IOException {
        if (input.reviewer == null) {
            throw new BadRequestException("missing reviewer field");
        }
        try {
            Account.Id accountId = this.accounts.parse(input.reviewer).getAccountId();
            return this.putAccount(this.reviewerFactory.create(rsrc, accountId));
        }
        catch (UnprocessableEntityException e) {
            try {
                return this.putGroup(rsrc, input);
            }
            catch (UnprocessableEntityException e2) {
                throw new UnprocessableEntityException(MessageFormat.format(ChangeMessages.get().reviewerNotFound, input.reviewer));
            }
        }
    }

    private ReviewerJson.PostResult putAccount(ReviewerResource rsrc) throws OrmException, EmailException, IOException {
        Account.Id id = rsrc.getUser().getAccountId();
        ChangeControl control = rsrc.getControl().forUser(this.identifiedUserFactory.create(id));
        ReviewerJson.PostResult result = new ReviewerJson.PostResult();
        this.addReviewers(rsrc, result, ImmutableMap.of(id, control));
        return result;
    }

    private ReviewerJson.PostResult putGroup(ChangeResource rsrc, AddReviewerInput input) throws BadRequestException, UnprocessableEntityException, OrmException, EmailException, IOException {
        Set<Account> members;
        GroupDescription.Basic group = this.groupsCollection.get().parseInternal(input.reviewer);
        ReviewerJson.PostResult result = new ReviewerJson.PostResult();
        if (!PostReviewers.isLegalReviewerGroup(group.getGroupUUID())) {
            result.error = MessageFormat.format(ChangeMessages.get().groupIsNotAllowed, group.getName());
            return result;
        }
        HashMap<Account.Id, ChangeControl> reviewers = Maps.newHashMap();
        ChangeControl control = rsrc.getControl();
        try {
            members = this.groupMembersFactory.create(control.getCurrentUser()).listAccounts(group.getGroupUUID(), control.getProject().getNameKey());
        }
        catch (NoSuchGroupException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (NoSuchProjectException e) {
            throw new BadRequestException(e.getMessage());
        }
        int maxAllowed = this.cfg.getInt("addreviewer", "maxAllowed", 20);
        if (maxAllowed > 0 && members.size() > maxAllowed) {
            result.error = MessageFormat.format(ChangeMessages.get().groupHasTooManyMembers, group.getName());
            return result;
        }
        int maxWithoutConfirmation = this.cfg.getInt("addreviewer", "maxWithoutConfirmation", 10);
        if (!input.confirmed() && maxWithoutConfirmation > 0 && members.size() > maxWithoutConfirmation) {
            result.confirm = true;
            result.error = MessageFormat.format(ChangeMessages.get().groupManyMembersConfirmation, group.getName(), members.size());
            return result;
        }
        for (Account member : members) {
            IdentifiedUser user;
            if (!member.isActive() || !control.forUser(user = this.identifiedUserFactory.create(member.getId())).isRefVisible()) continue;
            reviewers.put(user.getAccountId(), control);
        }
        this.addReviewers(rsrc, result, reviewers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReviewers(ChangeResource rsrc, ReviewerJson.PostResult result, Map<Account.Id, ChangeControl> reviewers) throws OrmException, EmailException, IOException {
        List<PatchSetApproval> added;
        ReviewDb db = this.dbProvider.get();
        ChangeUpdate update = this.updateFactory.create(rsrc.getControl());
        db.changes().beginTransaction(rsrc.getChange().getId());
        try {
            ChangeUtil.bumpRowVersionNotLastUpdatedOn(rsrc.getChange().getId(), db);
            added = this.approvalsUtil.addReviewers(db, rsrc.getNotes(), update, rsrc.getControl().getLabelTypes(), rsrc.getChange(), reviewers.keySet());
            db.commit();
        }
        finally {
            db.rollback();
        }
        update.commit();
        CheckedFuture<?, IOException> indexFuture = this.indexer.indexAsync(rsrc.getChange().getId());
        result.reviewers = Lists.newArrayListWithCapacity(added.size());
        for (PatchSetApproval psa : added) {
            result.reviewers.add(this.json.format(new ReviewerJson.ReviewerInfo(psa.getAccountId()), reviewers.get(psa.getAccountId()), ImmutableList.of(psa)));
        }
        this.accountLoaderFactory.create(true).fill(result.reviewers);
        this.postAdd(rsrc.getChange(), added);
        indexFuture.checkedGet();
    }

    private void postAdd(Change change, List<PatchSetApproval> added) throws OrmException, EmailException {
        if (added.isEmpty()) {
            return;
        }
        PatchSet patchSet = this.dbProvider.get().patchSets().get(change.currentPatchSetId());
        for (PatchSetApproval psa : added) {
            Account account = this.accountCache.get(psa.getAccountId()).getAccount();
            this.hooks.doReviewerAddedHook(change, account, patchSet, this.dbProvider.get());
        }
        ArrayList<Account.Id> toMail = Lists.newArrayListWithCapacity(added.size());
        for (PatchSetApproval psa : added) {
            if (psa.getAccountId().equals(this.currentUser.getAccountId())) continue;
            toMail.add(psa.getAccountId());
        }
        if (!toMail.isEmpty()) {
            try {
                AddReviewerSender cm = this.addReviewerSenderFactory.create(change);
                cm.setFrom(this.currentUser.getAccountId());
                cm.addReviewers(toMail);
                cm.send();
            }
            catch (Exception err) {
                log.error("Cannot send email to new reviewers of change " + change.getId(), err);
            }
        }
    }

    public static boolean isLegalReviewerGroup(AccountGroup.UUID groupUUID) {
        return !SystemGroupBackend.isSystemGroup(groupUUID);
    }
}

