/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.MergeQueue;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyFactory;
import com.google.gerrit.server.git.validators.MergeValidationException;
import com.google.gerrit.server.git.validators.MergeValidators;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.mail.MergeFailSender;
import com.google.gerrit.server.mail.MergedSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOp {
    private static final Logger log = LoggerFactory.getLogger(MergeOp.class);
    private static final long DEPENDENCY_DELAY = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    private static final long LOCK_FAILURE_RETRY_DELAY = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.SECONDS);
    private static final long MAX_SUBMIT_WINDOW = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private final GitRepositoryManager repoManager;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ChangeNotes.Factory notesFactory;
    private final ProjectCache projectCache;
    private final GitReferenceUpdated gitRefUpdated;
    private final MergedSender.Factory mergedSenderFactory;
    private final MergeFailSender.Factory mergeFailSenderFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final MergeQueue mergeQueue;
    private final MergeValidators.Factory mergeValidatorsFactory;
    private final ApprovalsUtil approvalsUtil;
    private final Branch.NameKey destBranch;
    private ProjectState destProject;
    private final ListMultimap<Project.SubmitType, CodeReviewCommit> toMerge;
    private final List<CodeReviewCommit> potentiallyStillSubmittable;
    private final Map<Change.Id, CodeReviewCommit> commits;
    private final List<Change> toUpdate;
    private ReviewDb db;
    private Repository repo;
    private RevWalk rw;
    private RevFlag canMergeFlag;
    private CodeReviewCommit branchTip;
    private CodeReviewCommit mergeTip;
    private ObjectInserter inserter;
    private PersonIdent refLogIdent;
    private final ChangeHooks hooks;
    private final AccountCache accountCache;
    private final TagCache tagCache;
    private final SubmitStrategyFactory submitStrategyFactory;
    private final SubmoduleOp.Factory subOpFactory;
    private final WorkQueue workQueue;
    private final RequestScopePropagator requestScopePropagator;
    private final ChangeIndexer indexer;

    @Inject
    MergeOp(GitRepositoryManager grm, SchemaFactory<ReviewDb> sf, ChangeNotes.Factory nf, ProjectCache pc, GitReferenceUpdated gru, MergedSender.Factory msf, MergeFailSender.Factory mfsf, PatchSetInfoFactory psif, IdentifiedUser.GenericFactory iuf, ChangeControl.GenericFactory changeControlFactory, MergeQueue mergeQueue, @Assisted Branch.NameKey branch, ChangeHooks hooks, AccountCache accountCache, TagCache tagCache, SubmitStrategyFactory submitStrategyFactory, SubmoduleOp.Factory subOpFactory, WorkQueue workQueue, RequestScopePropagator requestScopePropagator, ChangeIndexer indexer, MergeValidators.Factory mergeValidatorsFactory, ApprovalsUtil approvalsUtil) {
        this.repoManager = grm;
        this.schemaFactory = sf;
        this.notesFactory = nf;
        this.projectCache = pc;
        this.gitRefUpdated = gru;
        this.mergedSenderFactory = msf;
        this.mergeFailSenderFactory = mfsf;
        this.patchSetInfoFactory = psif;
        this.identifiedUserFactory = iuf;
        this.changeControlFactory = changeControlFactory;
        this.mergeQueue = mergeQueue;
        this.hooks = hooks;
        this.accountCache = accountCache;
        this.tagCache = tagCache;
        this.submitStrategyFactory = submitStrategyFactory;
        this.subOpFactory = subOpFactory;
        this.workQueue = workQueue;
        this.requestScopePropagator = requestScopePropagator;
        this.indexer = indexer;
        this.mergeValidatorsFactory = mergeValidatorsFactory;
        this.approvalsUtil = approvalsUtil;
        this.destBranch = branch;
        this.toMerge = ArrayListMultimap.create();
        this.potentiallyStillSubmittable = new ArrayList<CodeReviewCommit>();
        this.commits = new HashMap<Change.Id, CodeReviewCommit>();
        this.toUpdate = Lists.newArrayList();
    }

    private void setDestProject() throws MergeException {
        this.destProject = this.projectCache.get(this.destBranch.getParentKey());
        if (this.destProject == null) {
            throw new MergeException("No such project: " + this.destBranch.getParentKey());
        }
    }

    private void openSchema() throws OrmException {
        if (this.db == null) {
            this.db = this.schemaFactory.open();
        }
    }

    public void merge() throws MergeException {
        this.setDestProject();
        try {
            this.openSchema();
            this.openRepository();
            RefUpdate branchUpdate = this.openBranch();
            boolean reopen = false;
            ListMultimap<Project.SubmitType, Change> toSubmit = this.validateChangeList(this.db.changes().submitted(this.destBranch).toList());
            ArrayListMultimap<Project.SubmitType, CodeReviewCommit> toMergeNextTurn = ArrayListMultimap.create();
            ArrayList<CodeReviewCommit> potentiallyStillSubmittableOnNextRun = new ArrayList<CodeReviewCommit>();
            while (!this.toMerge.isEmpty()) {
                toMergeNextTurn.clear();
                HashSet submitTypes = new HashSet(this.toMerge.keySet());
                for (Project.SubmitType submitType : submitTypes) {
                    if (reopen) {
                        branchUpdate = this.openBranch();
                    }
                    SubmitStrategy strategy = this.createStrategy(submitType);
                    this.preMerge(strategy, this.toMerge.get(submitType));
                    RefUpdate update = this.updateBranch(strategy, branchUpdate);
                    reopen = true;
                    this.updateChangeStatus(toSubmit.get(submitType));
                    this.updateSubscriptions(toSubmit.get(submitType));
                    if (update != null) {
                        this.fireRefUpdated(update);
                    }
                    Iterator<CodeReviewCommit> it = this.potentiallyStillSubmittable.iterator();
                    while (it.hasNext()) {
                        CodeReviewCommit commit = it.next();
                        if (!this.containsMissingCommits(this.toMerge, commit) && !this.containsMissingCommits(toMergeNextTurn, commit)) continue;
                        it.remove();
                        commit.setStatusCode(null);
                        commit.missing = null;
                        toMergeNextTurn.put(submitType, commit);
                    }
                    potentiallyStillSubmittableOnNextRun.addAll(this.potentiallyStillSubmittable);
                    this.potentiallyStillSubmittable.clear();
                }
                this.toMerge.clear();
                this.toMerge.putAll(toMergeNextTurn);
            }
            this.updateChangeStatus(this.toUpdate);
            for (CodeReviewCommit commit : potentiallyStillSubmittableOnNextRun) {
                Capable capable = this.isSubmitStillPossible(commit);
                if (capable == Capable.OK) continue;
                this.sendMergeFail(commit.notes(), this.message(commit.change(), capable.getMessage()), false);
            }
        }
        catch (NoSuchProjectException noProject) {
            log.warn(String.format("Project %s no longer exists, abandoning open changes", this.destBranch.getParentKey().get()));
            this.abandonAllOpenChanges();
        }
        catch (OrmException e) {
            throw new MergeException("Cannot query the database", e);
        }
        finally {
            if (this.inserter != null) {
                this.inserter.release();
            }
            if (this.rw != null) {
                this.rw.release();
            }
            if (this.repo != null) {
                this.repo.close();
            }
            if (this.db != null) {
                this.db.close();
            }
        }
    }

    private boolean containsMissingCommits(ListMultimap<Project.SubmitType, CodeReviewCommit> map, CodeReviewCommit commit) {
        if (!this.isSubmitForMissingCommitsStillPossible(commit)) {
            return false;
        }
        for (CodeReviewCommit missingCommit : commit.missing) {
            if (map.containsValue(missingCommit)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubmitForMissingCommitsStillPossible(CodeReviewCommit commit) {
        if (commit.missing == null || commit.missing.isEmpty()) {
            return false;
        }
        for (CodeReviewCommit missingCommit : commit.missing) {
            try {
                this.loadChangeInfo(missingCommit);
            }
            catch (NoSuchChangeException | OrmException e) {
                log.error("Cannot check if missing commits can be submitted", e);
                return false;
            }
            if (missingCommit.getPatchsetId() == null) {
                return false;
            }
            if (missingCommit.change().currentPatchSetId().equals(missingCommit.getPatchsetId())) continue;
            return false;
        }
        return true;
    }

    private void preMerge(SubmitStrategy strategy, List<CodeReviewCommit> toMerge) throws MergeException {
        this.mergeTip = strategy.run(this.branchTip, toMerge);
        this.refLogIdent = strategy.getRefLogIdent();
        this.commits.putAll(strategy.getNewCommits());
    }

    private SubmitStrategy createStrategy(Project.SubmitType submitType) throws MergeException, NoSuchProjectException {
        return this.submitStrategyFactory.create(submitType, this.db, this.repo, this.rw, this.inserter, this.canMergeFlag, this.getAlreadyAccepted(this.branchTip), this.destBranch);
    }

    private void openRepository() throws MergeException, NoSuchProjectException {
        Project.NameKey name = this.destBranch.getParentKey();
        try {
            this.repo = this.repoManager.openRepository(name);
        }
        catch (RepositoryNotFoundException notFound) {
            throw new NoSuchProjectException(name, (Throwable)notFound);
        }
        catch (IOException err) {
            String m = "Error opening repository \"" + name.get() + '\"';
            throw new MergeException(m, err);
        }
        this.rw = new RevWalk(this.repo){

            @Override
            protected RevCommit createCommit(AnyObjectId id) {
                return new CodeReviewCommit(id);
            }
        };
        this.rw.sort(RevSort.TOPO);
        this.rw.sort(RevSort.COMMIT_TIME_DESC, true);
        this.canMergeFlag = this.rw.newFlag("CAN_MERGE");
        this.inserter = this.repo.newObjectInserter();
    }

    private RefUpdate openBranch() throws MergeException, OrmException {
        try {
            RefUpdate branchUpdate = this.repo.updateRef(this.destBranch.get());
            if (branchUpdate.getOldObjectId() != null) {
                this.branchTip = (CodeReviewCommit)this.rw.parseCommit(branchUpdate.getOldObjectId());
            } else if (this.repo.getFullBranch().equals(this.destBranch.get())) {
                this.branchTip = null;
                branchUpdate.setExpectedOldObjectId(ObjectId.zeroId());
            } else {
                for (Change c : this.db.changes().submitted(this.destBranch).toList()) {
                    this.setNew(c, this.message(c, "Your change could not be merged, because the destination branch does not exist anymore."));
                }
            }
            return branchUpdate;
        }
        catch (IOException e) {
            throw new MergeException("Cannot open branch", e);
        }
    }

    private Set<RevCommit> getAlreadyAccepted(CodeReviewCommit branchTip) throws MergeException {
        HashSet<RevCommit> alreadyAccepted = new HashSet<RevCommit>();
        if (branchTip != null) {
            alreadyAccepted.add(branchTip);
        }
        try {
            for (Ref r : this.repo.getRefDatabase().getRefs("").values()) {
                if (!r.getName().startsWith("refs/heads/")) continue;
                try {
                    alreadyAccepted.add(this.rw.parseCommit(r.getObjectId()));
                }
                catch (IncorrectObjectTypeException iote) {}
            }
        }
        catch (IOException e) {
            throw new MergeException("Failed to determine already accepted commits.", e);
        }
        return alreadyAccepted;
    }

    private ListMultimap<Project.SubmitType, Change> validateChangeList(List<Change> submitted) throws MergeException {
        Map<String, Ref> allRefs;
        ArrayListMultimap<Project.SubmitType, Change> toSubmit = ArrayListMultimap.create();
        try {
            allRefs = this.repo.getRefDatabase().getRefs("");
        }
        catch (IOException e) {
            throw new MergeException(e.getMessage(), e);
        }
        HashSet<ObjectId> tips = new HashSet<ObjectId>();
        for (Ref r : allRefs.values()) {
            tips.add(r.getObjectId());
        }
        int commitOrder = 0;
        for (Change chg : submitted) {
            Project.SubmitType submitType;
            CodeReviewCommit commit;
            ObjectId id;
            PatchSet ps;
            Change.Id changeId = chg.getId();
            if (chg.currentPatchSetId() == null) {
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.NO_PATCH_SET));
                this.toUpdate.add(chg);
                continue;
            }
            try {
                ps = this.db.patchSets().get(chg.currentPatchSetId());
            }
            catch (OrmException e) {
                throw new MergeException("Cannot query the database", e);
            }
            if (ps == null || ps.getRevision() == null || ps.getRevision().get() == null) {
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.NO_PATCH_SET));
                this.toUpdate.add(chg);
                continue;
            }
            String idstr = ps.getRevision().get();
            try {
                id = ObjectId.fromString(idstr);
            }
            catch (IllegalArgumentException iae) {
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.NO_PATCH_SET));
                this.toUpdate.add(chg);
                continue;
            }
            if (!tips.contains(id)) {
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.REVISION_GONE));
                this.toUpdate.add(chg);
                continue;
            }
            try {
                commit = (CodeReviewCommit)this.rw.parseCommit(id);
            }
            catch (IOException e) {
                log.error("Invalid commit " + id.name() + " on " + chg.getKey(), e);
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.REVISION_GONE));
                this.toUpdate.add(chg);
                continue;
            }
            try {
                commit.setControl(this.changeControlFactory.controlFor(chg, (CurrentUser)this.identifiedUserFactory.create(chg.getOwner())));
            }
            catch (NoSuchChangeException e) {
                throw new MergeException("Failed to validate changes", e);
            }
            commit.setPatchsetId(ps.getId());
            commit.originalOrder = commitOrder++;
            MergeValidators mergeValidators = this.mergeValidatorsFactory.create();
            try {
                mergeValidators.validatePreMerge(this.repo, commit, this.destProject, this.destBranch, ps.getId());
            }
            catch (MergeValidationException mve) {
                this.commits.put(changeId, CodeReviewCommit.error(mve.getStatus()));
                this.toUpdate.add(chg);
                continue;
            }
            this.commits.put(changeId, commit);
            if (this.branchTip != null) {
                try {
                    if (this.rw.isMergedInto(commit, this.branchTip)) {
                        commit.setStatusCode(CommitMergeStatus.ALREADY_MERGED);
                        try {
                            this.setMerged(chg, null);
                        }
                        catch (OrmException e) {
                            log.error("Cannot mark change " + chg.getId() + " merged", e);
                        }
                        continue;
                    }
                }
                catch (IOException err) {
                    throw new MergeException("Cannot perform merge base test", err);
                }
            }
            if ((submitType = this.getSubmitType(commit.getControl(), ps)) == null) {
                this.commits.put(changeId, CodeReviewCommit.error(CommitMergeStatus.NO_SUBMIT_TYPE));
                this.toUpdate.add(chg);
                continue;
            }
            commit.add(this.canMergeFlag);
            this.toMerge.put(submitType, commit);
            toSubmit.put(submitType, chg);
        }
        return toSubmit;
    }

    private Project.SubmitType getSubmitType(ChangeControl ctl, PatchSet ps) {
        SubmitTypeRecord r = ctl.getSubmitTypeRecord(this.db, ps);
        if (r.status != SubmitTypeRecord.Status.OK) {
            log.error("Failed to get submit type for " + ctl.getChange().getKey());
            return null;
        }
        return r.type;
    }

    private RefUpdate updateBranch(SubmitStrategy strategy, RefUpdate branchUpdate) throws MergeException {
        if (this.branchTip == this.mergeTip || this.mergeTip == null) {
            return null;
        }
        if ("refs/meta/config".equals(branchUpdate.getName())) {
            try {
                ProjectConfig cfg = new ProjectConfig(this.destProject.getProject().getNameKey());
                cfg.load(this.repo, (ObjectId)this.mergeTip);
            }
            catch (Exception e) {
                throw new MergeException("Submit would store invalid project configuration " + this.mergeTip.name() + " for " + this.destProject.getProject().getName(), e);
            }
        }
        branchUpdate.setRefLogIdent(this.refLogIdent);
        branchUpdate.setForceUpdate(false);
        branchUpdate.setNewObjectId(this.mergeTip);
        branchUpdate.setRefLogMessage("merged", true);
        try {
            switch (branchUpdate.update(this.rw)) {
                case NEW: 
                case FAST_FORWARD: {
                    if (branchUpdate.getResult() == RefUpdate.Result.FAST_FORWARD) {
                        this.tagCache.updateFastForward(this.destBranch.getParentKey(), branchUpdate.getName(), branchUpdate.getOldObjectId(), this.mergeTip);
                    }
                    if ("refs/meta/config".equals(branchUpdate.getName())) {
                        this.projectCache.evict(this.destProject.getProject());
                        this.destProject = this.projectCache.get(this.destProject.getProject().getNameKey());
                        this.repoManager.setProjectDescription(this.destProject.getProject().getNameKey(), this.destProject.getProject().getDescription());
                    }
                    return branchUpdate;
                }
                case LOCK_FAILURE: {
                    String msg;
                    if (strategy.retryOnLockFailure()) {
                        this.mergeQueue.recheckAfter(this.destBranch, LOCK_FAILURE_RETRY_DELAY, TimeUnit.MILLISECONDS);
                        msg = "will retry";
                    } else {
                        msg = "will not retry";
                    }
                    throw new IOException(branchUpdate.getResult().name() + ", " + msg);
                }
            }
            throw new IOException(branchUpdate.getResult().name());
        }
        catch (IOException e) {
            throw new MergeException("Cannot update " + branchUpdate.getName(), e);
        }
    }

    private void fireRefUpdated(RefUpdate branchUpdate) {
        this.gitRefUpdated.fire(this.destBranch.getParentKey(), branchUpdate);
        Account account = null;
        PatchSetApproval submitter = this.approvalsUtil.getSubmitter(this.db, this.mergeTip.notes(), this.mergeTip.getPatchsetId());
        if (submitter != null) {
            account = this.accountCache.get(submitter.getAccountId()).getAccount();
        }
        this.hooks.doRefUpdatedHook(this.destBranch, branchUpdate, account);
    }

    private void updateChangeStatus(List<Change> submitted) {
        for (Change c : submitted) {
            CommitMergeStatus s;
            CodeReviewCommit commit = this.commits.get(c.getId());
            CommitMergeStatus commitMergeStatus = s = commit != null ? commit.getStatusCode() : null;
            if (s == null) continue;
            String txt = s.getMessage();
            try {
                switch (s) {
                    case CLEAN_MERGE: {
                        this.setMerged(c, this.message(c, txt));
                        break;
                    }
                    case CLEAN_REBASE: 
                    case CLEAN_PICK: {
                        this.setMerged(c, this.message(c, txt + " as " + commit.name()));
                        break;
                    }
                    case ALREADY_MERGED: {
                        this.setMerged(c, null);
                        break;
                    }
                    case PATH_CONFLICT: 
                    case MANUAL_RECURSIVE_MERGE: 
                    case CANNOT_CHERRY_PICK_ROOT: 
                    case NOT_FAST_FORWARD: 
                    case INVALID_PROJECT_CONFIGURATION: 
                    case INVALID_PROJECT_CONFIGURATION_PLUGIN_VALUE_NOT_PERMITTED: 
                    case INVALID_PROJECT_CONFIGURATION_PLUGIN_VALUE_NOT_EDITABLE: 
                    case INVALID_PROJECT_CONFIGURATION_PARENT_PROJECT_NOT_FOUND: 
                    case INVALID_PROJECT_CONFIGURATION_ROOT_PROJECT_CANNOT_HAVE_PARENT: 
                    case SETTING_PARENT_PROJECT_ONLY_ALLOWED_BY_ADMIN: {
                        this.setNew(commit, this.message(c, txt));
                        break;
                    }
                    case MISSING_DEPENDENCY: {
                        this.potentiallyStillSubmittable.add(commit);
                        break;
                    }
                    default: {
                        this.setNew(commit, this.message(c, "Unspecified merge failure: " + s.name()));
                        break;
                    }
                }
            }
            catch (OrmException err) {
                log.warn("Error updating change status for " + c.getId(), err);
            }
            catch (IOException err) {
                log.warn("Error updating change status for " + c.getId(), err);
            }
        }
    }

    private void updateSubscriptions(List<Change> submitted) {
        if (this.mergeTip != null && (this.branchTip == null || this.branchTip != this.mergeTip)) {
            SubmoduleOp subOp = this.subOpFactory.create(this.destBranch, this.mergeTip, this.rw, this.repo, this.destProject.getProject(), submitted, this.commits);
            try {
                subOp.update();
            }
            catch (SubmoduleException e) {
                log.error("The gitLinks were not updated according to the subscriptions " + e.getMessage());
            }
        }
    }

    private Capable isSubmitStillPossible(CodeReviewCommit commit) {
        Capable capable;
        Change c = commit.change();
        boolean submitStillPossible = this.isSubmitForMissingCommitsStillPossible(commit);
        long now = TimeUtil.nowMs();
        long waitUntil = c.getLastUpdatedOn().getTime() + DEPENDENCY_DELAY;
        if (submitStillPossible && now < waitUntil) {
            this.mergeQueue.recheckAfter(this.destBranch, waitUntil - now, TimeUnit.MILLISECONDS);
            capable = Capable.OK;
        } else if (submitStillPossible) {
            StringBuilder m = new StringBuilder();
            m.append("Change could not be merged because of a missing dependency.");
            m.append("\n");
            m.append("\n");
            m.append("The following changes must also be submitted:\n");
            m.append("\n");
            for (CodeReviewCommit missingCommit : commit.missing) {
                m.append("* ");
                m.append(missingCommit.change().getKey().get());
                m.append("\n");
            }
            capable = new Capable(m.toString());
        } else {
            StringBuilder m = new StringBuilder();
            m.append("Change cannot be merged due to unsatisfiable dependencies.\n");
            m.append("\n");
            m.append("The following dependency errors were found:\n");
            m.append("\n");
            for (CodeReviewCommit missingCommit : commit.missing) {
                if (missingCommit.getPatchsetId() != null) {
                    m.append("* Depends on patch set ");
                    m.append(missingCommit.getPatchsetId().get());
                    m.append(" of ");
                    m.append(missingCommit.change().getKey().abbreviate());
                    if (missingCommit.getPatchsetId().get() != missingCommit.change().currentPatchSetId().get()) {
                        m.append(", however the current patch set is ");
                        m.append(missingCommit.change().currentPatchSetId().get());
                    }
                    m.append(".\n");
                    continue;
                }
                m.append("* Depends on commit ");
                m.append(missingCommit.name());
                m.append(" which has no change associated with it.\n");
            }
            m.append("\n");
            m.append("Please rebase the change and upload a replacement commit.");
            capable = new Capable(m.toString());
        }
        return capable;
    }

    private void loadChangeInfo(CodeReviewCommit commit) throws NoSuchChangeException, OrmException {
        List<PatchSet> matches;
        if (commit.getControl() == null && (matches = this.db.patchSets().byRevision(new RevId(commit.name())).toList()).size() == 1) {
            PatchSet ps = matches.get(0);
            commit.setPatchsetId(ps.getId());
            commit.setControl(this.changeControl(this.db.changes().get(ps.getId().getParentKey())));
        }
    }

    private ChangeMessage message(Change c, String body) {
        String uuid;
        try {
            uuid = ChangeUtil.messageUUID(this.db);
        }
        catch (OrmException e) {
            return null;
        }
        ChangeMessage m = new ChangeMessage(new ChangeMessage.Key(c.getId(), uuid), null, TimeUtil.nowTs(), c.currentPatchSetId());
        m.setMessage(body);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMerged(Change c, ChangeMessage msg) throws OrmException, IOException {
        try {
            this.db.changes().beginTransaction(c.getId());
            CodeReviewCommit commit = this.commits.get(c.getId());
            PatchSet.Id merged = commit.change().currentPatchSetId();
            c = this.setMergedPatchSet(c.getId(), merged);
            PatchSetApproval submitter = this.approvalsUtil.getSubmitter(this.db, commit.notes(), merged);
            this.addMergedMessage(submitter, msg);
            this.db.commit();
            this.sendMergedEmail(c, submitter);
            if (submitter != null) {
                try {
                    this.hooks.doChangeMergedHook(c, this.accountCache.get(submitter.getAccountId()).getAccount(), this.db.patchSets().get(merged), this.db);
                }
                catch (OrmException ex) {
                    log.error("Cannot run hook for submitted patch set " + c.getId(), ex);
                }
            }
        }
        finally {
            this.db.rollback();
        }
        this.indexer.index(this.db, c);
    }

    private Change setMergedPatchSet(Change.Id changeId, final PatchSet.Id merged) throws OrmException {
        return this.db.changes().atomicUpdate(changeId, new AtomicUpdate<Change>(){

            @Override
            public Change update(Change c) {
                c.setStatus(Change.Status.MERGED);
                c.setMergeable(true);
                if (!merged.equals(c.currentPatchSetId())) {
                    try {
                        c.setCurrentPatchSet(MergeOp.this.patchSetInfoFactory.get(MergeOp.this.db, merged));
                    }
                    catch (PatchSetInfoNotAvailableException e1) {
                        log.error("Cannot read merged patch set " + merged, e1);
                    }
                }
                ChangeUtil.updated(c);
                return c;
            }
        });
    }

    private void addMergedMessage(PatchSetApproval submitter, ChangeMessage msg) throws OrmException {
        if (msg != null) {
            if (submitter != null && msg.getAuthor() == null) {
                msg.setAuthor(submitter.getAccountId());
            }
            this.db.changeMessages().insert(Collections.singleton(msg));
        }
    }

    private void sendMergedEmail(final Change c, final PatchSetApproval from) {
        this.workQueue.getDefaultQueue().submit(this.requestScopePropagator.wrap(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PatchSet patchSet;
                try (ReviewDb reviewDb = (ReviewDb)MergeOp.this.schemaFactory.open();){
                    patchSet = reviewDb.patchSets().get(c.currentPatchSetId());
                }
                catch (Exception e) {
                    log.error("Cannot send email for submitted patch set " + c.getId(), e);
                    return;
                }
                try {
                    MergedSender cm = MergeOp.this.mergedSenderFactory.create(MergeOp.this.changeControl(c));
                    if (from != null) {
                        cm.setFrom(from.getAccountId());
                    }
                    cm.setPatchSet(patchSet);
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot send email for submitted patch set " + c.getId(), e);
                }
            }

            public String toString() {
                return "send-email merged";
            }
        }));
    }

    private ChangeControl changeControl(Change c) throws NoSuchChangeException {
        return this.changeControlFactory.controlFor(c, (CurrentUser)this.identifiedUserFactory.create(c.getOwner()));
    }

    private void setNew(CodeReviewCommit c, ChangeMessage msg) {
        this.sendMergeFail(c.notes(), msg, true);
    }

    private void setNew(Change c, ChangeMessage msg) throws OrmException {
        this.sendMergeFail(this.notesFactory.create(c), msg, true);
    }

    private RetryStatus getRetryStatus(@Nullable PatchSetApproval submitter, ChangeMessage msg) {
        if (submitter != null && TimeUtil.nowMs() - submitter.getGranted().getTime() > MAX_SUBMIT_WINDOW) {
            return RetryStatus.UNSUBMIT;
        }
        try {
            ChangeMessage last = Iterables.getLast(this.db.changeMessages().byChange(msg.getPatchSetId().getParentKey()), null);
            if (last != null && Objects.equal(last.getAuthor(), msg.getAuthor()) && Objects.equal(last.getMessage(), msg.getMessage())) {
                long lastMs = last.getWrittenOn().getTime();
                long msgMs = msg.getWrittenOn().getTime();
                return msgMs - lastMs > MAX_SUBMIT_WINDOW ? RetryStatus.UNSUBMIT : RetryStatus.RETRY_NO_MESSAGE;
            }
            return RetryStatus.RETRY_ADD_MESSAGE;
        }
        catch (OrmException err) {
            log.warn("Cannot check previous merge failure, unsubmitting", err);
            return RetryStatus.UNSUBMIT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMergeFail(ChangeNotes notes, final ChangeMessage msg, boolean makeNew) {
        PatchSetApproval submitter = null;
        try {
            submitter = this.approvalsUtil.getSubmitter(this.db, notes, notes.getChange().currentPatchSetId());
        }
        catch (Exception e) {
            log.error("Cannot get submitter", e);
        }
        if (!makeNew) {
            RetryStatus retryStatus = this.getRetryStatus(submitter, msg);
            if (retryStatus == RetryStatus.RETRY_NO_MESSAGE) {
                return;
            }
            if (retryStatus == RetryStatus.UNSUBMIT) {
                makeNew = true;
            }
        }
        final boolean setStatusNew = makeNew;
        final Change c = notes.getChange();
        Change change = null;
        try {
            this.db.changes().beginTransaction(c.getId());
            try {
                change = this.db.changes().atomicUpdate(c.getId(), new AtomicUpdate<Change>(){

                    @Override
                    public Change update(Change c) {
                        if (c.getStatus().isOpen()) {
                            if (setStatusNew) {
                                c.setStatus(Change.Status.NEW);
                            }
                            ChangeUtil.updated(c);
                        }
                        return c;
                    }
                });
                this.db.changeMessages().insert(Collections.singleton(msg));
                this.db.commit();
            }
            finally {
                this.db.rollback();
            }
        }
        catch (OrmException err) {
            log.warn("Cannot record merge failure message", err);
        }
        CheckedFuture<?, IOException> indexFuture = change != null ? this.indexer.indexAsync(change.getId()) : null;
        final PatchSetApproval from = submitter;
        this.workQueue.getDefaultQueue().submit(this.requestScopePropagator.wrap(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PatchSet patchSet;
                try (ReviewDb reviewDb = (ReviewDb)MergeOp.this.schemaFactory.open();){
                    patchSet = reviewDb.patchSets().get(c.currentPatchSetId());
                }
                catch (Exception e) {
                    log.error("Cannot send email notifications about merge failure", e);
                    return;
                }
                try {
                    MergeFailSender cm = MergeOp.this.mergeFailSenderFactory.create(c);
                    if (from != null) {
                        cm.setFrom(from.getAccountId());
                    }
                    cm.setPatchSet(patchSet);
                    cm.setChangeMessage(msg);
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot send email notifications about merge failure", e);
                }
            }

            public String toString() {
                return "send-email merge-failed";
            }
        }));
        if (submitter != null) {
            try {
                this.hooks.doMergeFailedHook(c, this.accountCache.get(submitter.getAccountId()).getAccount(), this.db.patchSets().get(c.currentPatchSetId()), msg.getMessage(), this.db);
            }
            catch (OrmException ex) {
                log.error("Cannot run hook for merge failed " + c.getId(), ex);
            }
        }
        if (indexFuture != null) {
            try {
                indexFuture.checkedGet();
            }
            catch (IOException e) {
                log.error("Failed to index new change message", e);
            }
        }
    }

    private void abandonAllOpenChanges() {
        Exception err = null;
        try {
            this.openSchema();
            for (Change c : this.db.changes().byProjectOpenAll(this.destBranch.getParentKey())) {
                this.abandonOneChange(c);
            }
            this.db.close();
            this.db = null;
        }
        catch (IOException e) {
            err = e;
        }
        catch (OrmException e) {
            err = e;
        }
        if (err != null) {
            log.warn(String.format("Cannot abandon changes for deleted project %s", this.destBranch.getParentKey().get()), err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abandonOneChange(Change change) throws OrmException, IOException {
        this.db.changes().beginTransaction(change.getId());
        try {
            change = this.db.changes().atomicUpdate(change.getId(), new AtomicUpdate<Change>(){

                @Override
                public Change update(Change change) {
                    if (change.getStatus().isOpen()) {
                        change.setStatus(Change.Status.ABANDONED);
                        return change;
                    }
                    return null;
                }
            });
            if (change != null) {
                ChangeMessage msg = new ChangeMessage(new ChangeMessage.Key(change.getId(), ChangeUtil.messageUUID(this.db)), null, change.getLastUpdatedOn(), change.currentPatchSetId());
                msg.setMessage("Project was deleted.");
                this.db.changeMessages().insert(Collections.singleton(msg));
                this.db.commit();
                this.indexer.index(this.db, change);
            }
        }
        finally {
            this.db.rollback();
        }
    }

    private static enum RetryStatus {
        UNSUBMIT,
        RETRY_NO_MESSAGE,
        RETRY_ADD_MESSAGE;

    }

    public static interface Factory {
        public MergeOp create(Branch.NameKey var1);
    }
}

