/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.MergeSorter;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class SubmitStrategy {
    private PersonIdent refLogIdent;
    protected final Arguments args;

    SubmitStrategy(Arguments args) {
        this.args = args;
    }

    public final CodeReviewCommit run(CodeReviewCommit mergeTip, List<CodeReviewCommit> toMerge) throws MergeException {
        this.refLogIdent = null;
        return this._run(mergeTip, toMerge);
    }

    protected abstract CodeReviewCommit _run(CodeReviewCommit var1, List<CodeReviewCommit> var2) throws MergeException;

    public abstract boolean dryRun(CodeReviewCommit var1, CodeReviewCommit var2) throws MergeException;

    public final PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public Map<Change.Id, CodeReviewCommit> getNewCommits() {
        return Collections.emptyMap();
    }

    public boolean retryOnLockFailure() {
        return true;
    }

    protected final void setRefLogIdent(PatchSetApproval submitApproval) {
        if (this.refLogIdent == null && submitApproval != null) {
            this.refLogIdent = this.args.identifiedUserFactory.create(submitApproval.getAccountId()).newRefLogIdent();
        }
    }

    static class Arguments {
        protected final IdentifiedUser.GenericFactory identifiedUserFactory;
        protected final PersonIdent myIdent;
        protected final ReviewDb db;
        protected final ChangeControl.GenericFactory changeControlFactory;
        protected final Repository repo;
        protected final RevWalk rw;
        protected final ObjectInserter inserter;
        protected final RevFlag canMergeFlag;
        protected final Set<RevCommit> alreadyAccepted;
        protected final Branch.NameKey destBranch;
        protected final ApprovalsUtil approvalsUtil;
        protected final MergeUtil mergeUtil;
        protected final ChangeIndexer indexer;
        protected final MergeSorter mergeSorter;

        Arguments(IdentifiedUser.GenericFactory identifiedUserFactory, PersonIdent myIdent, ReviewDb db, ChangeControl.GenericFactory changeControlFactory, Repository repo, RevWalk rw, ObjectInserter inserter, RevFlag canMergeFlag, Set<RevCommit> alreadyAccepted, Branch.NameKey destBranch, ApprovalsUtil approvalsUtil, MergeUtil mergeUtil, ChangeIndexer indexer) {
            this.identifiedUserFactory = identifiedUserFactory;
            this.myIdent = myIdent;
            this.db = db;
            this.changeControlFactory = changeControlFactory;
            this.repo = repo;
            this.rw = rw;
            this.inserter = inserter;
            this.canMergeFlag = canMergeFlag;
            this.alreadyAccepted = alreadyAccepted;
            this.destBranch = destBranch;
            this.approvalsUtil = approvalsUtil;
            this.mergeUtil = mergeUtil;
            this.indexer = indexer;
            this.mergeSorter = new MergeSorter(rw, alreadyAccepted, canMergeFlag);
        }
    }
}

