/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.Collections;

public class PutDescription
implements RestModifyView<GroupResource, Input> {
    private final GroupCache groupCache;
    private final ReviewDb db;

    @Inject
    PutDescription(GroupCache groupCache, ReviewDb db) {
        this.groupCache = groupCache;
        this.db = db;
    }

    public Response<String> apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException {
        if (input == null) {
            input = new Input();
        }
        if (resource.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        AccountGroup group = this.db.accountGroups().get(resource.toAccountGroup().getId());
        if (group == null) {
            throw new ResourceNotFoundException();
        }
        group.setDescription(Strings.emptyToNull(input.description));
        this.db.accountGroups().update(Collections.singleton(group));
        this.groupCache.evict(group);
        return Strings.isNullOrEmpty(input.description) ? Response.none() : Response.ok(input.description);
    }

    public static class Input {
        @DefaultInput
        public String description;
    }
}

