/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.mail.EmailTokenVerifier;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.ValidToken;
import com.google.gwtjsonrpc.server.XsrfException;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.util.Base64;

public class SignedTokenEmailTokenVerifier
implements EmailTokenVerifier {
    private final SignedToken emailRegistrationToken;

    @Inject
    SignedTokenEmailTokenVerifier(AuthConfig config) {
        this.emailRegistrationToken = config.getEmailRegistrationToken();
    }

    @Override
    public String encode(Account.Id accountId, String emailAddress) {
        try {
            String payload = String.format("%s:%s", accountId, emailAddress);
            byte[] utf8 = payload.getBytes("UTF-8");
            String base64 = Base64.encodeBytes(utf8);
            return this.emailRegistrationToken.newToken(base64);
        }
        catch (XsrfException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public EmailTokenVerifier.ParsedToken decode(String tokenString) throws EmailTokenVerifier.InvalidTokenException {
        Account.Id id;
        String payload;
        ValidToken token;
        try {
            token = this.emailRegistrationToken.checkToken(tokenString, null);
        }
        catch (XsrfException err) {
            throw new EmailTokenVerifier.InvalidTokenException(err);
        }
        if (token == null || token.getData() == null || token.getData().isEmpty()) {
            throw new EmailTokenVerifier.InvalidTokenException();
        }
        try {
            payload = new String(Base64.decode(token.getData()), "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new EmailTokenVerifier.InvalidTokenException(err);
        }
        Matcher matcher = Pattern.compile("^([0-9]+):(.+@.+)$").matcher(payload);
        if (!matcher.matches()) {
            throw new EmailTokenVerifier.InvalidTokenException();
        }
        try {
            id = Account.Id.parse(matcher.group(1));
        }
        catch (IllegalArgumentException err) {
            throw new EmailTokenVerifier.InvalidTokenException(err);
        }
        String newEmail = matcher.group(2);
        return new EmailTokenVerifier.ParsedToken(id, newEmail);
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(EmailTokenVerifier.class).to(SignedTokenEmailTokenVerifier.class);
        }
    }
}

