/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.StringUtil;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectNode;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.util.TreeFormatter;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProjects
implements RestReadView<TopLevelResource> {
    private static final Logger log = LoggerFactory.getLogger(ListProjects.class);
    private final CurrentUser currentUser;
    private final ProjectCache projectCache;
    private final GroupCache groupCache;
    private final GroupControl.Factory groupControlFactory;
    private final GitRepositoryManager repoManager;
    private final ProjectNode.Factory projectNodeFactory;
    @Deprecated
    @Option(name="--format", usage="(deprecated) output format")
    private OutputFormat format = OutputFormat.TEXT;
    private final List<String> showBranch = Lists.newArrayList();
    private boolean showTree;
    private FilterType type = FilterType.CODE;
    private boolean showDescription;
    private boolean all;
    private int limit;
    private int start;
    private String matchPrefix;
    private String matchSubstring;
    private AccountGroup.UUID groupUuid;

    @Option(name="--show-branch", aliases={"-b"}, usage="displays the sha of each project in the specified branch")
    public void addShowBranch(String branch) {
        this.showBranch.add(branch);
    }

    @Option(name="--tree", aliases={"-t"}, usage="displays project inheritance in a tree-like format\nthis option does not work together with the show-branch option")
    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    @Option(name="--type", usage="type of project")
    public void setFilterType(FilterType type) {
        this.type = type;
    }

    @Option(name="--description", aliases={"-d"}, usage="include description of project in list")
    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Option(name="--all", usage="display all projects that are accessible by the calling user")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of projects to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="-S", metaVar="CNT", usage="number of projects to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="-p", metaVar="PREFIX", usage="match project prefix")
    public void setMatchPrefix(String matchPrefix) {
        this.matchPrefix = matchPrefix;
    }

    @Option(name="-m", metaVar="MATCH", usage="match project substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="--has-acl-for", metaVar="GROUP", usage="displays only projects on which access rights for this group are directly assigned")
    public void setGroupUuid(AccountGroup.UUID groupUuid) {
        this.groupUuid = groupUuid;
    }

    @Inject
    protected ListProjects(CurrentUser currentUser, ProjectCache projectCache, GroupCache groupCache, GroupControl.Factory groupControlFactory, GitRepositoryManager repoManager, ProjectNode.Factory projectNodeFactory) {
        this.currentUser = currentUser;
        this.projectCache = projectCache;
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.repoManager = repoManager;
        this.projectNodeFactory = projectNodeFactory;
    }

    public List<String> getShowBranch() {
        return this.showBranch;
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public ListProjects setFormat(OutputFormat fmt) {
        this.format = fmt;
        return this;
    }

    @Override
    public Object apply(TopLevelResource resource) {
        if (this.format == OutputFormat.TEXT) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            this.display(buf);
            return BinaryResult.create(buf.toByteArray()).setContentType("text/plain").setCharacterEncoding("UTF-8");
        }
        return this.apply();
    }

    public Map<String, ProjectJson.ProjectInfo> apply() {
        this.format = OutputFormat.JSON;
        return this.display(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ProjectJson.ProjectInfo> display(OutputStream displayOutputStream) {
        PrintWriter stdout = null;
        if (displayOutputStream != null) {
            try {
                stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(displayOutputStream, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM lacks UTF-8 encoding", e);
            }
        }
        int foundIndex = 0;
        int found = 0;
        TreeMap<String, ProjectJson.ProjectInfo> output = Maps.newTreeMap();
        HashMap<String, String> hiddenNames = Maps.newHashMap();
        HashSet<String> rejected = new HashSet<String>();
        TreeMap<Project.NameKey, ProjectNode> treeMap = new TreeMap<Project.NameKey, ProjectNode>();
        try {
            TreeMap<String, ProjectJson.ProjectInfo> treeMap2;
            for (Project.NameKey projectName : this.scan()) {
                ProjectJson.ProjectInfo info;
                block47: {
                    ProjectState parent;
                    boolean isVisible;
                    ProjectState e = this.projectCache.get(projectName);
                    if (e == null) continue;
                    ProjectControl pctl = e.controlFor(this.currentUser);
                    if (this.groupUuid != null) {
                        try {
                            if (!this.groupControlFactory.controlFor(this.groupUuid).isVisible()) {
                            }
                        }
                        catch (NoSuchGroupException ex) {}
                        break;
                        if (!pctl.getLocalGroups().contains(GroupReference.forGroup(this.groupCache.get(this.groupUuid)))) continue;
                    }
                    info = new ProjectJson.ProjectInfo();
                    if (this.type == FilterType.PARENT_CANDIDATES) {
                        ProjectState parentState = Iterables.getFirst(e.parents(), null);
                        if (parentState == null || output.keySet().contains(parentState.getProject().getName()) || rejected.contains(parentState.getProject().getName())) continue;
                        ProjectControl parentCtrl = parentState.controlFor(this.currentUser);
                        if (parentCtrl.isVisible() || parentCtrl.isOwner()) {
                            info.name = parentState.getProject().getName();
                            info.description = Strings.emptyToNull(parentState.getProject().getDescription());
                            info.state = parentState.getProject().getState();
                            break block47;
                        } else {
                            rejected.add(parentState.getProject().getName());
                            continue;
                        }
                    }
                    boolean bl = isVisible = pctl.isVisible() || this.all && pctl.isOwner();
                    if (this.showTree && !this.format.isJson()) {
                        treeMap.put(projectName, this.projectNodeFactory.create(pctl.getProject(), isVisible));
                        continue;
                    }
                    if (!isVisible && (!this.showTree || !pctl.isOwner())) continue;
                    info.name = projectName.get();
                    if (this.showTree && this.format.isJson() && (parent = (ProjectState)Iterables.getFirst(e.parents(), null)) != null) {
                        ProjectControl parentCtrl = parent.controlFor(this.currentUser);
                        if (parentCtrl.isVisible() || parentCtrl.isOwner()) {
                            info.parent = parent.getProject().getName();
                        } else {
                            info.parent = (String)hiddenNames.get(parent.getProject().getName());
                            if (info.parent == null) {
                                info.parent = "?-" + (hiddenNames.size() + 1);
                                hiddenNames.put(parent.getProject().getName(), info.parent);
                            }
                        }
                    }
                    if (this.showDescription) {
                        info.description = Strings.emptyToNull(e.getProject().getDescription());
                    }
                    info.state = e.getProject().getState();
                    try {
                        Repository git;
                        if (!this.showBranch.isEmpty()) {
                            git = this.repoManager.openRepository(projectName);
                            try {
                                List<Ref> refs;
                                if (!this.type.matches(git) || !ListProjects.hasValidRef(refs = this.getBranchRefs(projectName, pctl))) continue;
                                for (int i = 0; i < this.showBranch.size(); ++i) {
                                    Ref ref = refs.get(i);
                                    if (ref == null || ref.getObjectId() == null) continue;
                                    if (info.branches == null) {
                                        info.branches = Maps.newLinkedHashMap();
                                    }
                                    info.branches.put(this.showBranch.get(i), ref.getObjectId().name());
                                }
                                break block47;
                            }
                            finally {
                                git.close();
                                continue;
                            }
                        }
                        if (this.showTree || this.type == FilterType.ALL) break block47;
                        git = this.repoManager.openRepository(projectName);
                        try {
                            if (!this.type.matches(git)) {
                                continue;
                            }
                            break block47;
                        }
                        finally {
                            git.close();
                        }
                    }
                    catch (RepositoryNotFoundException err) {
                    }
                    catch (IOException err) {
                        log.warn("Unexpected error reading " + projectName, err);
                    }
                    continue;
                }
                if (foundIndex++ < this.start) continue;
                if (this.limit > 0 && ++found > this.limit) break;
                if (stdout == null || this.format.isJson()) {
                    output.put(info.name, info);
                    continue;
                }
                if (!this.showBranch.isEmpty()) {
                    for (String name : this.showBranch) {
                        String ref;
                        String string = ref = info.branches != null ? info.branches.get(name) : null;
                        if (ref == null) {
                            ref = "----------------------------------------";
                        }
                        stdout.print(ref);
                        stdout.print(' ');
                    }
                }
                stdout.print(info.name);
                if (info.description != null) {
                    stdout.print(" - " + StringUtil.escapeString(info.description));
                }
                stdout.print('\n');
            }
            for (ProjectJson.ProjectInfo info : output.values()) {
                info.finish();
                info.name = null;
            }
            if (stdout == null) {
                treeMap2 = output;
                return treeMap2;
            }
            if (this.format.isJson()) {
                this.format.newGson().toJson(output, new TypeToken<Map<String, ProjectJson.ProjectInfo>>(){}.getType(), stdout);
                stdout.print('\n');
            } else if (this.showTree && treeMap.size() > 0) {
                this.printProjectTree(stdout, treeMap);
            }
            treeMap2 = null;
            return treeMap2;
        }
        finally {
            if (stdout != null) {
                stdout.flush();
            }
        }
    }

    private Iterable<Project.NameKey> scan() {
        if (this.matchPrefix != null) {
            return this.projectCache.byName(this.matchPrefix);
        }
        if (this.matchSubstring != null) {
            return Iterables.filter(this.projectCache.all(), new Predicate<Project.NameKey>(){

                @Override
                public boolean apply(Project.NameKey in) {
                    return in.get().toLowerCase(Locale.US).contains(ListProjects.this.matchSubstring.toLowerCase(Locale.US));
                }
            });
        }
        return this.projectCache.all();
    }

    private void printProjectTree(PrintWriter stdout, TreeMap<Project.NameKey, ProjectNode> treeMap) {
        TreeSet<ProjectNode> sortedNodes = new TreeSet<ProjectNode>();
        for (ProjectNode key : treeMap.values()) {
            if (key.isAllProjects()) {
                sortedNodes.add(key);
                continue;
            }
            ProjectNode node = treeMap.get(key.getParentName());
            if (node != null) {
                node.addChild(key);
                continue;
            }
            sortedNodes.add(key);
        }
        TreeFormatter treeFormatter = new TreeFormatter(stdout);
        treeFormatter.printTree(sortedNodes);
        stdout.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Ref> getBranchRefs(Project.NameKey projectName, ProjectControl projectControl) {
        Ref[] result = new Ref[this.showBranch.size()];
        try (Repository git = this.repoManager.openRepository(projectName);){
            for (int i = 0; i < this.showBranch.size(); ++i) {
                Ref ref = git.getRef(this.showBranch.get(i));
                if ((ref == null || ref.getObjectId() == null || !projectControl.controlForRef(ref.getLeaf().getName()).isVisible()) && (!this.all || !projectControl.isOwner())) continue;
                result[i] = ref;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return Arrays.asList(result);
    }

    private static boolean hasValidRef(List<Ref> refs) {
        for (Ref ref : refs) {
            if (ref == null) continue;
            return true;
        }
        return false;
    }

    public static enum FilterType {
        CODE{

            @Override
            boolean matches(Repository git) throws IOException {
                return !PERMISSIONS.matches(git);
            }
        }
        ,
        PARENT_CANDIDATES{

            @Override
            boolean matches(Repository git) {
                return true;
            }
        }
        ,
        PERMISSIONS{

            @Override
            boolean matches(Repository git) throws IOException {
                Ref head = git.getRef("HEAD");
                return head != null && head.isSymbolic() && "refs/meta/config".equals(head.getLeaf().getName());
            }
        }
        ,
        ALL{

            @Override
            boolean matches(Repository git) {
                return true;
            }
        };


        abstract boolean matches(Repository var1) throws IOException;
    }
}

