/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.util.ArrayList;

public final class ChangeStatusPredicate
extends IndexPredicate<ChangeData> {
    public static final ImmutableBiMap<Change.Status, String> VALUES;
    private final Change.Status status;

    public static Predicate<ChangeData> open(Provider<ReviewDb> dbProvider) {
        ArrayList<ChangeStatusPredicate> r = new ArrayList<ChangeStatusPredicate>(4);
        for (Change.Status e : Change.Status.values()) {
            if (!e.isOpen()) continue;
            r.add(new ChangeStatusPredicate(e));
        }
        return r.size() == 1 ? (Predicate)r.get(0) : ChangeStatusPredicate.or(r);
    }

    public static Predicate<ChangeData> closed(Provider<ReviewDb> dbProvider) {
        ArrayList<ChangeStatusPredicate> r = new ArrayList<ChangeStatusPredicate>(4);
        for (Change.Status e : Change.Status.values()) {
            if (!e.isClosed()) continue;
            r.add(new ChangeStatusPredicate(e));
        }
        return r.size() == 1 ? (Predicate)r.get(0) : ChangeStatusPredicate.or(r);
    }

    ChangeStatusPredicate(String value) {
        super(ChangeField.STATUS, value);
        this.status = (Change.Status)((Object)((ImmutableMap)((Object)VALUES.inverse())).get(value));
        Preconditions.checkArgument(this.status != null, "invalid change status: %s", value);
    }

    ChangeStatusPredicate(Change.Status status) {
        super(ChangeField.STATUS, (String)VALUES.get((Object)status));
        this.status = status;
    }

    public Change.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        return change != null && this.status.equals((Object)change.getStatus());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int hashCode() {
        return this.status.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ChangeStatusPredicate) {
            ChangeStatusPredicate p = (ChangeStatusPredicate)other;
            return this.status.equals((Object)p.status);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getOperator() + ":" + this.getValue();
    }

    static {
        ImmutableBiMap.Builder values = ImmutableBiMap.builder();
        for (Change.Status s : Change.Status.values()) {
            values.put((Object)s, s.name().toLowerCase());
        }
        VALUES = values.build();
    }
}

