/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.EqualsLabelPredicate;
import com.google.gerrit.server.util.LabelVote;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelPredicate
extends OrPredicate<ChangeData> {
    private static final int MAX_LABEL_VALUE = 4;
    private final String value;

    LabelPredicate(ProjectCache projectCache, ChangeControl.GenericFactory ccFactory, IdentifiedUser.GenericFactory userFactory, Provider<ReviewDb> dbProvider, String value, Set<Account.Id> accounts, AccountGroup.UUID group) {
        super(LabelPredicate.predicates(new Args(projectCache, ccFactory, userFactory, dbProvider, value, accounts, group)));
        this.value = value;
    }

    private static List<Predicate<ChangeData>> predicates(Args args) {
        int min;
        int max;
        LabelVote lv;
        String v = args.value;
        Parsed parsed = null;
        try {
            lv = LabelVote.parse(v);
            parsed = new Parsed(lv.getLabel(), "=", lv.getValue());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            lv = LabelVote.parseWithEquals(v);
            parsed = new Parsed(lv.getLabel(), "=", lv.getValue());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (parsed == null) {
            Matcher m = Pattern.compile("(>|>=|=|<|<=)([+-]?\\d+)$").matcher(v);
            parsed = m.find() ? new Parsed(v.substring(0, m.start()), m.group(1), LabelPredicate.value(m.group(2))) : new Parsed(v, "=", 1);
        }
        switch (parsed.test) {
            default: {
                min = max = parsed.expVal;
                break;
            }
            case ">": {
                min = parsed.expVal + 1;
                max = 4;
                break;
            }
            case ">=": {
                min = parsed.expVal;
                max = 4;
                break;
            }
            case "<": {
                min = -4;
                max = parsed.expVal - 1;
                break;
            }
            case "<=": {
                min = -4;
                max = parsed.expVal;
            }
        }
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayListWithCapacity(max - min + 1);
        for (int i = min; i <= max; ++i) {
            r.add(LabelPredicate.onePredicate(args, parsed.label, i));
        }
        return r;
    }

    private static Predicate<ChangeData> onePredicate(Args args, String label, int expVal) {
        if (expVal != 0) {
            return LabelPredicate.equalsLabelPredicate(args, label, expVal);
        }
        return LabelPredicate.noLabelQuery(args, label);
    }

    private static int value(String value) {
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }

    private static Predicate<ChangeData> noLabelQuery(Args args, String label) {
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayListWithCapacity(8);
        for (int i = 1; i <= 4; ++i) {
            r.add(LabelPredicate.not(LabelPredicate.equalsLabelPredicate(args, label, i)));
            r.add(LabelPredicate.not(LabelPredicate.equalsLabelPredicate(args, label, -i)));
        }
        return LabelPredicate.and(r);
    }

    private static Predicate<ChangeData> equalsLabelPredicate(Args args, String label, int expVal) {
        if (args.accounts == null || args.accounts.isEmpty()) {
            return new EqualsLabelPredicate(args, label, expVal, null);
        }
        ArrayList<EqualsLabelPredicate> r = Lists.newArrayList();
        for (Account.Id a : args.accounts) {
            r.add(new EqualsLabelPredicate(args, label, expVal, a));
        }
        return LabelPredicate.or(r);
    }

    @Override
    public String toString() {
        return "label:" + this.value;
    }

    private static class Parsed {
        private final String label;
        private final String test;
        private final int expVal;

        private Parsed(String label, String test, int expVal) {
            this.label = label;
            this.test = test;
            this.expVal = expVal;
        }
    }

    static class Args {
        final ProjectCache projectCache;
        final ChangeControl.GenericFactory ccFactory;
        final IdentifiedUser.GenericFactory userFactory;
        final Provider<ReviewDb> dbProvider;
        final String value;
        final Set<Account.Id> accounts;
        final AccountGroup.UUID group;

        private Args(ProjectCache projectCache, ChangeControl.GenericFactory ccFactory, IdentifiedUser.GenericFactory userFactory, Provider<ReviewDb> dbProvider, String value, Set<Account.Id> accounts, AccountGroup.UUID group) {
            this.projectCache = projectCache;
            this.ccFactory = ccFactory;
            this.userFactory = userFactory;
            this.dbProvider = dbProvider;
            this.value = value;
            this.accounts = accounts;
            this.group = group;
        }
    }
}

