/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_55;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class Schema_56
extends SchemaVersion {
    private final GitRepositoryManager mgr;
    private final Set<String> keysOne;
    private final Set<String> keysTwo;

    @Inject
    Schema_56(Provider<Schema_55> prior, GitRepositoryManager mgr) {
        super(prior);
        this.mgr = mgr;
        this.keysOne = new HashSet<String>();
        this.keysTwo = new HashSet<String>();
        this.keysOne.add("refs/meta/config");
        this.keysTwo.add("refs/meta/config");
        this.keysTwo.add("HEAD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) {
        for (Project.NameKey name : this.mgr.list()) {
            Map<String, Ref> all;
            Repository git;
            try {
                git = this.mgr.openRepository(name);
            }
            catch (IOException e) {
                ui.message("warning: Cannot open " + name.get());
                continue;
            }
            try {
                all = git.getRefDatabase().getRefs("");
            }
            catch (IOException e) {
                ui.message("warning: " + name.get() + ": Cannot read refs: " + e.getMessage());
                e.printStackTrace();
                git.close();
                continue;
            }
            try {
                if (!all.keySet().equals(this.keysOne) && !all.keySet().equals(this.keysTwo)) continue;
                try {
                    RefUpdate update = git.updateRef("HEAD");
                    update.disableRefLog();
                    update.link("refs/meta/config");
                }
                catch (IOException err) {
                    ui.message("warning: " + name.get() + ": Cannot update HEAD to " + "refs/meta/config" + ": " + err.getMessage());
                }
            }
            finally {
                git.close();
            }
        }
    }
}

