/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import java.util.ArrayList;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;

class HostKeyProvider
implements Provider<KeyPairProvider> {
    private final SitePaths site;

    @Inject
    HostKeyProvider(SitePaths site) {
        this.site = site;
    }

    @Override
    public KeyPairProvider get() {
        File objKey = this.site.ssh_key;
        File rsaKey = this.site.ssh_rsa;
        File dsaKey = this.site.ssh_dsa;
        ArrayList<String> stdKeys = new ArrayList<String>(2);
        if (rsaKey.exists()) {
            stdKeys.add(rsaKey.getAbsolutePath());
        }
        if (dsaKey.exists()) {
            stdKeys.add(dsaKey.getAbsolutePath());
        }
        if (objKey.exists()) {
            if (stdKeys.isEmpty()) {
                SimpleGeneratorHostKeyProvider p = new SimpleGeneratorHostKeyProvider();
                p.setPath(objKey.getAbsolutePath());
                return p;
            }
            stdKeys.add(objKey.getAbsolutePath());
            throw new ProvisionException("Multiple host keys exist: " + stdKeys);
        }
        if (stdKeys.isEmpty()) {
            throw new ProvisionException("No SSH keys under " + this.site.etc_dir);
        }
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new ProvisionException("Bouncy Castle Crypto not installed; needed to read server host keys: " + stdKeys + "");
        }
        return new FileKeyPairProvider(stdKeys.toArray(new String[stdKeys.size()]));
    }
}

