/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.args4j.Argument;

@AdminHighPriorityCommand
@RequiresCapability(value="killTask")
final class KillCommand
extends SshCommand {
    @Inject
    private WorkQueue workQueue;
    private final Set<Integer> taskIds = new HashSet<Integer>();

    KillCommand() {
    }

    @Argument(index=0, multiValued=true, required=true, metaVar="ID")
    void addTaskId(String taskId) {
        int p;
        for (p = 0; p < taskId.length() - 1 && taskId.charAt(p) == '0'; ++p) {
        }
        this.taskIds.add((int)Long.parseLong(taskId.substring(p), 16));
    }

    @Override
    protected void run() {
        for (Integer id : this.taskIds) {
            WorkQueue.Task<?> task = this.workQueue.getTask(id);
            if (task != null) {
                task.cancel(true);
                continue;
            }
            this.stderr.print("kill: " + IdGenerator.format(id) + ": No such task\n");
        }
    }
}

