/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="set-project", description="Change a project's settings")
final class SetProjectCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(SetProjectCommand.class);
    @Argument(index=0, required=true, metaVar="NAME", usage="name of the project")
    private ProjectControl projectControl;
    @Option(name="--description", aliases={"-d"}, metaVar="DESCRIPTION", usage="description of project")
    private String projectDescription;
    @Option(name="--submit-type", aliases={"-t"}, usage="project submit type\n(default: MERGE_IF_NECESSARY)")
    private Project.SubmitType submitType;
    @Option(name="--contributor-agreements", usage="if contributor agreement is required")
    private Project.InheritableBoolean contributorAgreements;
    @Option(name="--signed-off-by", usage="if signed-off-by is required")
    private Project.InheritableBoolean signedOffBy;
    @Option(name="--content-merge", usage="allow automatic conflict resolving within files")
    private Project.InheritableBoolean contentMerge;
    @Option(name="--change-id", usage="if change-id is required")
    private Project.InheritableBoolean requireChangeID;
    @Option(name="--project-state", aliases={"--ps"}, usage="project's visibility state")
    private Project.State state;
    @Option(name="--max-object-size-limit", usage="max Git object size for this project")
    private String maxObjectSizeLimit;
    @Inject
    private MetaDataUpdate.User metaDataUpdateFactory;
    @Inject
    private ProjectCache projectCache;

    SetProjectCommand() {
    }

    @Option(name="--use-contributor-agreements", aliases={"--ca"}, usage="if contributor agreement is required")
    void setUseContributorArgreements(boolean on) {
        this.contributorAgreements = Project.InheritableBoolean.TRUE;
    }

    @Option(name="--no-contributor-agreements", aliases={"--nca"}, usage="if contributor agreement is not required")
    void setNoContributorArgreements(boolean on) {
        this.contributorAgreements = Project.InheritableBoolean.FALSE;
    }

    @Option(name="--use-signed-off-by", aliases={"--so"}, usage="if signed-off-by is required")
    void setUseSignedOffBy(boolean on) {
        this.signedOffBy = Project.InheritableBoolean.TRUE;
    }

    @Option(name="--no-signed-off-by", aliases={"--nso"}, usage="if signed-off-by is not required")
    void setNoSignedOffBy(boolean on) {
        this.signedOffBy = Project.InheritableBoolean.FALSE;
    }

    @Option(name="--use-content-merge", usage="allow automatic conflict resolving within files")
    void setUseContentMerge(boolean on) {
        this.contentMerge = Project.InheritableBoolean.TRUE;
    }

    @Option(name="--no-content-merge", usage="don't allow automatic conflict resolving within files")
    void setNoContentMerge(boolean on) {
        this.contentMerge = Project.InheritableBoolean.FALSE;
    }

    @Option(name="--require-change-id", aliases={"--id"}, usage="if change-id is required")
    void setRequireChangeId(boolean on) {
        this.requireChangeID = Project.InheritableBoolean.TRUE;
    }

    @Option(name="--no-change-id", aliases={"--nid"}, usage="if change-id is not required")
    void setNoChangeId(boolean on) {
        this.requireChangeID = Project.InheritableBoolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws BaseCommand.Failure {
        String msg;
        Project ctlProject = this.projectControl.getProject();
        Project.NameKey nameKey = ctlProject.getNameKey();
        String name = ctlProject.getName();
        StringBuilder err = new StringBuilder();
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(nameKey);){
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            if (this.requireChangeID != null) {
                project.setRequireChangeID(this.requireChangeID);
            }
            if (this.submitType != null) {
                project.setSubmitType(this.submitType);
            }
            if (this.contentMerge != null) {
                project.setUseContentMerge(this.contentMerge);
            }
            if (this.contributorAgreements != null) {
                project.setUseContributorAgreements(this.contributorAgreements);
            }
            if (this.signedOffBy != null) {
                project.setUseSignedOffBy(this.signedOffBy);
            }
            if (this.projectDescription != null) {
                project.setDescription(this.projectDescription);
            }
            if (this.state != null) {
                project.setState(this.state);
            }
            if (this.maxObjectSizeLimit != null) {
                project.setMaxObjectSizeLimit(this.maxObjectSizeLimit);
            }
            md.setMessage("Project settings updated");
            config.commit(md);
        }
        catch (RepositoryNotFoundException notFound) {
            err.append("error: Project ").append(name).append(" not found\n");
        }
        catch (IOException e) {
            msg = "Cannot update project " + name;
            log.error(msg, e);
            err.append("error: ").append(msg).append("\n");
        }
        catch (ConfigInvalidException e) {
            msg = "Cannot update project " + name;
            log.error(msg, e);
            err.append("error: ").append(msg).append("\n");
        }
        this.projectCache.evict(ctlProject);
        if (err.length() > 0) {
            while (err.charAt(err.length() - 1) == '\n') {
                err.setLength(err.length() - 1);
            }
            throw new BaseCommand.UnloggedFailure(1, err.toString());
        }
    }
}

