/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.jdbc.JdbcAccess;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.KeyModel;
import com.google.gwtorm.schema.QueryModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.CodeGenSupport;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class AccessGen
implements Opcodes {
    private static final String REL_ALIAS = "T";
    private final GeneratedClassLoader classLoader;
    private final RelationModel model;
    private final SqlDialect dialect;
    private ClassWriter cw;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;
    private Type entityType;

    AccessGen(GeneratedClassLoader loader, RelationModel rm, SqlDialect sd) {
        this.classLoader = loader;
        this.model = rm;
        this.dialect = sd;
        this.entityType = Type.getObjectType(this.model.getEntityTypeClassName().replace('.', '/'));
    }

    public Class<?> create() throws OrmException {
        this.init();
        this.implementConstructor();
        this.implementGetString("getRelationName", this.model.getRelationName());
        this.implementGetString("getInsertOneSql", this.model.getInsertOneSql(this.dialect));
        this.implementGetRelationID();
        if (this.model.getPrimaryKey() != null) {
            if (this.model.getDependentColumns().isEmpty()) {
                this.implementMissingGetString("getUpdateOneSql", "update");
            } else {
                this.implementGetString("getUpdateOneSql", this.model.getUpdateOneSql(this.dialect));
            }
            this.implementGetString("getDeleteOneSql", this.model.getDeleteOneSql(this.dialect));
        } else {
            this.implementMissingGetString("getUpdateOneSql", "update");
            this.implementMissingGetString("getDeleteOneSql", "delete");
        }
        this.implementPrimaryKey();
        this.implementGetOne();
        this.implementNewEntityInstance();
        this.implementBindOne(DmlType.INSERT);
        this.implementBindOne(DmlType.UPDATE);
        this.implementBindOne(DmlType.DELETE);
        this.implementBindOneFetch();
        if (this.model.getPrimaryKey() != null) {
            this.implementKeyQuery(this.model.getPrimaryKey());
            if ((this.model.getPrimaryKey().getField().isNested() || !this.model.getPrimaryKey().getField().getPrimitiveType().isPrimitive()) && this.model.getPrimaryKey().getAllLeafColumns().size() == 1) {
                this.overrideGetMany();
            }
        }
        for (QueryModel q : this.model.getQueries()) {
            this.implementQuery(q);
        }
        this.implementQuery(new QueryModel(this.model, "iterateAllEntities", ""));
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
        return this.loadClass();
    }

    private Class<?> loadClass() throws OrmException {
        try {
            return Class.forName(this.implClassName, false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new OrmException("Cannot load generated class", err);
        }
    }

    private void init() {
        this.superTypeName = Type.getInternalName(JdbcAccess.class);
        this.implClassName = this.model.getEntityTypeClassName() + "_Access_" + this.model.getMethodName() + "_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, new String[]{this.model.getAccessInterfaceName().replace('.', '/')});
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(JdbcSchema.class));
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetString(String methodName, String returnValue) {
        MethodVisitor mv = this.cw.visitMethod(17, methodName, Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), null, null);
        mv.visitCode();
        mv.visitLdcInsn(returnValue);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetRelationID() {
        MethodVisitor mv = this.cw.visitMethod(17, "getRelationID", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), null, null);
        mv.visitCode();
        new CodeGenSupport(mv).push(this.model.getRelationID());
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementMissingGetString(String methodName, String why) {
        MethodVisitor mv = this.cw.visitMethod(17, methodName, Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), null, null);
        mv.visitCode();
        this.throwUnsupported(mv, this.model.getMethodName() + " does not support " + why);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void throwUnsupported(MethodVisitor mv, String message) {
        Type eType = Type.getType(UnsupportedOperationException.class);
        mv.visitTypeInsn(187, eType.getInternalName());
        mv.visitInsn(89);
        mv.visitLdcInsn(message);
        mv.visitMethodInsn(183, eType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class)));
        mv.visitInsn(191);
    }

    private void implementPrimaryKey() {
        KeyModel pk = this.model.getPrimaryKey();
        MethodVisitor mv = this.cw.visitMethod(17, "primaryKey", Type.getMethodDescriptor(Type.getType(Key.class), Type.getType(Object.class)), null, null);
        mv.visitCode();
        if (pk != null && pk.getField().isNested()) {
            ColumnModel pkf = pk.getField();
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, this.entityType.getInternalName());
            mv.visitFieldInsn(180, this.entityType.getInternalName(), pkf.getFieldName(), CodeGenSupport.toType(pkf).getDescriptor());
        } else {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetOne() {
        KeyModel pk = this.model.getPrimaryKey();
        MethodVisitor mv = this.cw.visitMethod(17, "get", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Key.class)), null, new String[]{Type.getType(OrmException.class).getInternalName()});
        mv.visitCode();
        if (pk != null && pk.getField().isNested()) {
            Type keyType = CodeGenSupport.toType(pk.getField());
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, keyType.getInternalName());
            mv.visitMethodInsn(182, this.implTypeName, pk.getName(), Type.getMethodDescriptor(this.entityType, keyType));
            mv.visitInsn(176);
        } else {
            this.throwUnsupported(mv, this.model.getMethodName() + " does not support get(Key)");
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementNewEntityInstance() {
        MethodVisitor mv = this.cw.visitMethod(17, "newEntityInstance", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.entityType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.entityType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementBindOne(DmlType type) {
        MethodVisitor mv = this.cw.visitMethod(17, type.methodName, Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(PreparedStatement.class), Type.getType(Object.class)), null, new String[]{Type.getType(SQLException.class).getInternalName()});
        mv.visitCode();
        if (type != DmlType.INSERT && this.model.getPrimaryKey() == null) {
            this.throwUnsupported(mv, this.model.getMethodName() + " has no primary key");
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.entityType.getInternalName());
        mv.visitVarInsn(58, 2);
        CodeGenSupport cgs = new CodeGenSupport(mv);
        cgs.setEntityType(this.entityType);
        for (ColumnModel col : this.model.getRowVersionColumns()) {
            cgs.setFieldReference(col);
            cgs.fieldSetBegin();
            cgs.pushFieldValue();
            mv.visitInsn(4);
            mv.visitInsn(96);
            cgs.fieldSetEnd();
        }
        cgs.resetColumnIndex(0);
        if (type != DmlType.DELETE) {
            ArrayList<ColumnModel> cols = new ArrayList<ColumnModel>();
            cols.addAll(this.model.getDependentFields());
            cols.addAll(this.model.getRowVersionFields());
            for (ColumnModel field : cols) {
                this.doBindOne(mv, cgs, field);
            }
        }
        for (ColumnModel col : this.model.getPrimaryKeyColumns()) {
            cgs.setFieldReference(col);
            this.dialect.getSqlTypeInfo(col).generatePreparedStatementSet(cgs);
        }
        if (type != DmlType.INSERT) {
            for (ColumnModel col : this.model.getRowVersionColumns()) {
                cgs.setFieldReference(col);
                cgs.pushSqlHandle();
                cgs.pushColumnIndex();
                cgs.pushFieldValue();
                mv.visitInsn(4);
                mv.visitInsn(100);
                cgs.invokePreparedStatementSet("Int");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void doBindOne(MethodVisitor mv, CodeGenSupport cgs, ColumnModel field) {
        if (field.isNested() && field.isNotNull()) {
            for (ColumnModel c : field.getAllLeafColumns()) {
                this.doBindOne(mv, cgs, c);
            }
        } else if (field.isNested()) {
            int colIdx = cgs.getColumnIndex();
            Label isnull = new Label();
            Label end = new Label();
            cgs.setFieldReference(field);
            cgs.pushFieldValue();
            mv.visitJumpInsn(198, isnull);
            cgs.resetColumnIndex(colIdx);
            for (ColumnModel c : field.getNestedColumns()) {
                this.doBindOne(mv, cgs, c);
            }
            mv.visitJumpInsn(167, end);
            mv.visitLabel(isnull);
            cgs.resetColumnIndex(colIdx);
            for (ColumnModel c : field.getAllLeafColumns()) {
                cgs.setFieldReference(c);
                this.dialect.getSqlTypeInfo(c).generatePreparedStatementNull(cgs);
            }
            mv.visitLabel(end);
        } else {
            cgs.setFieldReference(field);
            this.dialect.getSqlTypeInfo(field).generatePreparedStatementSet(cgs);
        }
    }

    private void implementBindOneFetch() {
        MethodVisitor mv = this.cw.visitMethod(17, "bindOneFetch", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(java.sql.ResultSet.class), Type.getType(Object.class)), null, new String[]{Type.getType(SQLException.class).getInternalName()});
        mv.visitCode();
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.entityType.getInternalName());
        mv.visitVarInsn(58, 2);
        CodeGenSupport cgs = new CodeGenSupport(mv);
        cgs.setEntityType(this.entityType);
        if (this.model.getPrimaryKey() != null && this.model.getPrimaryKey().getField().isNested()) {
            ColumnModel pkf = this.model.getPrimaryKey().getField();
            Type vType = CodeGenSupport.toType(pkf);
            int oldIdx = cgs.getColumnIndex();
            cgs.setFieldReference(pkf);
            cgs.fieldSetBegin();
            mv.visitTypeInsn(187, vType.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, vType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            cgs.fieldSetEnd();
            cgs.resetColumnIndex(oldIdx);
        }
        ArrayList<ColumnModel> cols = new ArrayList<ColumnModel>();
        cols.addAll(this.model.getDependentFields());
        cols.addAll(this.model.getRowVersionFields());
        cols.addAll(this.model.getPrimaryKeyColumns());
        for (ColumnModel field : cols) {
            this.doFetchOne(mv, cgs, field, -1);
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void doFetchOne(MethodVisitor mv, CodeGenSupport cgs, ColumnModel field, int reportLiveInto) {
        if (field.isNested()) {
            int livecnt;
            int oldIdx = cgs.getColumnIndex();
            Type vType = CodeGenSupport.toType(field);
            if (field.isNotNull()) {
                livecnt = -1;
            } else {
                livecnt = cgs.newLocal();
                cgs.push(0);
                mv.visitVarInsn(54, livecnt);
            }
            cgs.setFieldReference(field);
            cgs.fieldSetBegin();
            mv.visitTypeInsn(187, vType.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, vType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            cgs.fieldSetEnd();
            cgs.resetColumnIndex(oldIdx);
            for (ColumnModel c : field.getNestedColumns()) {
                this.doFetchOne(mv, cgs, c, livecnt);
            }
            if (livecnt >= 0) {
                oldIdx = cgs.getColumnIndex();
                Label islive = new Label();
                mv.visitVarInsn(21, livecnt);
                mv.visitJumpInsn(154, islive);
                cgs.setFieldReference(field);
                cgs.fieldSetBegin();
                mv.visitInsn(1);
                cgs.fieldSetEnd();
                if (reportLiveInto >= 0) {
                    Label end = new Label();
                    mv.visitJumpInsn(167, end);
                    mv.visitLabel(islive);
                    mv.visitIincInsn(reportLiveInto, 1);
                    mv.visitLabel(end);
                } else {
                    mv.visitLabel(islive);
                }
                cgs.resetColumnIndex(oldIdx);
                cgs.freeLocal(livecnt);
            }
        } else {
            int dupTo = reportLiveInto >= 0 && CodeGenSupport.toType(field).getSort() == 10 ? cgs.newLocal() : -1;
            cgs.setFieldReference(field);
            cgs.setDupOnFieldSetEnd(dupTo);
            this.dialect.getSqlTypeInfo(field).generateResultSetGet(cgs);
            if (reportLiveInto >= 0) {
                Label wasnull = new Label();
                if (dupTo >= 0) {
                    mv.visitVarInsn(25, dupTo);
                    mv.visitJumpInsn(198, wasnull);
                    cgs.freeLocal(dupTo);
                } else {
                    cgs.pushSqlHandle();
                    mv.visitMethodInsn(185, Type.getType(java.sql.ResultSet.class).getInternalName(), "wasNull", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]));
                    mv.visitJumpInsn(154, wasnull);
                }
                mv.visitIincInsn(reportLiveInto, 1);
                mv.visitLabel(wasnull);
            }
        }
    }

    private void implementKeyQuery(KeyModel info) {
        final Type keyType = CodeGenSupport.toType(info.getField());
        StringBuilder query = new StringBuilder();
        query.append(this.model.getSelectSql(this.dialect, REL_ALIAS));
        query.append(" WHERE ");
        int nth = 1;
        Iterator<ColumnModel> i = info.getAllLeafColumns().iterator();
        while (i.hasNext()) {
            ColumnModel c = i.next();
            query.append(REL_ALIAS);
            query.append('.');
            query.append(c.getColumnName());
            query.append('=');
            query.append(this.dialect.getParameterPlaceHolder(nth++));
            if (!i.hasNext()) continue;
            query.append(" AND ");
        }
        MethodVisitor mv = this.cw.visitMethod(17, info.getName(), Type.getMethodDescriptor(this.entityType, keyType), null, new String[]{Type.getType(OrmException.class).getInternalName()});
        mv.visitCode();
        boolean keyvar = true;
        final int psvar = 1 + keyType.getSize();
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(query.toString());
        mv.visitMethodInsn(182, this.superTypeName, "prepareStatement", Type.getMethodDescriptor(Type.getType(PreparedStatement.class), Type.getType(String.class)));
        mv.visitVarInsn(58, psvar);
        CodeGenSupport cgs = new CodeGenSupport(mv){

            @Override
            public void pushSqlHandle() {
                this.mv.visitVarInsn(25, psvar);
            }

            @Override
            public void pushFieldValue() {
                this.appendGetField(this.getFieldReference());
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                if (c.getParent() == null) {
                    this.loadVar(keyType, 1);
                } else {
                    super.appendGetField(c);
                }
            }
        };
        for (ColumnModel c : info.getAllLeafColumns()) {
            cgs.setFieldReference(c);
            this.dialect.getSqlTypeInfo(c).generatePreparedStatementSet(cgs);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, psvar);
        mv.visitMethodInsn(182, this.superTypeName, "queryOne", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(PreparedStatement.class)));
        mv.visitTypeInsn(192, this.entityType.getInternalName());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void overrideGetMany() {
        KeyModel pk = this.model.getPrimaryKey();
        StringBuilder query = new StringBuilder();
        query.append(this.model.getSelectSql(this.dialect, REL_ALIAS));
        query.append(" WHERE ");
        ColumnModel pkcol = pk.getAllLeafColumns().iterator().next();
        query.append(REL_ALIAS);
        query.append('.');
        query.append(pkcol.getColumnName());
        query.append(" IN");
        MethodVisitor mv = this.cw.visitMethod(17, "getBySqlIn", Type.getMethodDescriptor(Type.getType(ResultSet.class), Type.getType(Collection.class)), null, new String[]{Type.getType(OrmException.class).getInternalName()});
        mv.visitCode();
        boolean keyset = true;
        int psvar = 2;
        int itrvar = 3;
        int colvar = 4;
        int keyvar = 5;
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(query.toString());
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, this.superTypeName, "prepareBySqlIn", Type.getMethodDescriptor(Type.getType(PreparedStatement.class), Type.getType(String.class), Type.getType(Collection.class)));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Collection.class), "iterator", Type.getMethodDescriptor(Type.getType(Iterator.class), new Type[0]));
        mv.visitVarInsn(58, 3);
        mv.visitInsn(4);
        mv.visitVarInsn(54, 4);
        Label endbind = new Label();
        Label again = new Label();
        mv.visitLabel(again);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(185, Type.getInternalName(Iterator.class), "hasNext", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]));
        mv.visitJumpInsn(153, endbind);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(185, Type.getInternalName(Iterator.class), "next", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]));
        mv.visitTypeInsn(192, CodeGenSupport.toType(pk.getField()).getInternalName());
        mv.visitVarInsn(58, 5);
        CodeGenSupport cgs = new CodeGenSupport(mv){

            @Override
            public void pushSqlHandle() {
                this.mv.visitVarInsn(25, 2);
            }

            @Override
            public void pushFieldValue() {
                this.appendGetField(this.getFieldReference());
            }

            @Override
            public void pushColumnIndex() {
                this.mv.visitVarInsn(21, 4);
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                if (c.getParent() == null) {
                    this.mv.visitVarInsn(25, 5);
                } else {
                    super.appendGetField(c);
                }
            }
        };
        cgs.setFieldReference(pkcol);
        this.dialect.getSqlTypeInfo(pkcol).generatePreparedStatementSet(cgs);
        mv.visitIincInsn(4, 1);
        mv.visitJumpInsn(167, again);
        mv.visitLabel(endbind);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, this.superTypeName, "queryList", Type.getMethodDescriptor(Type.getType(ResultSet.class), Type.getType(PreparedStatement.class)));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementQuery(QueryModel info) {
        final List<ColumnModel> pCols = info.getParameters();
        boolean hasLimitParam = info.hasLimitParameter();
        final Type[] pTypes = new Type[pCols.size() + (hasLimitParam ? 1 : 0)];
        final int[] pVars = new int[pTypes.length];
        int nextVar = 1;
        for (int i = 0; i < pCols.size(); ++i) {
            pTypes[i] = CodeGenSupport.toType(pCols.get(i));
            pVars[i] = nextVar;
            nextVar += pTypes[i].getSize();
        }
        if (hasLimitParam) {
            pTypes[pTypes.length - 1] = Type.INT_TYPE;
            pVars[pTypes.length - 1] = nextVar;
            nextVar += Type.INT_TYPE.getSize();
        }
        final int psvar = nextVar++;
        MethodVisitor mv = this.cw.visitMethod(17, info.getName(), Type.getMethodDescriptor(Type.getType(ResultSet.class), pTypes), null, new String[]{Type.getType(OrmException.class).getInternalName()});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(info.getSelectSql(this.dialect, REL_ALIAS));
        mv.visitMethodInsn(182, this.superTypeName, "prepareStatement", Type.getMethodDescriptor(Type.getType(PreparedStatement.class), Type.getType(String.class)));
        mv.visitVarInsn(58, psvar);
        final int[] argIdx = new int[]{0};
        CodeGenSupport cgs = new CodeGenSupport(mv){

            @Override
            public void pushSqlHandle() {
                this.mv.visitVarInsn(25, psvar);
            }

            @Override
            public void pushFieldValue() {
                this.appendGetField(this.getFieldReference());
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                int n = argIdx[0];
                if (c == pCols.get(n)) {
                    this.loadVar(pTypes[n], pVars[n]);
                } else {
                    super.appendGetField(c);
                }
            }
        };
        for (ColumnModel c : pCols) {
            if (c.isNested()) {
                for (ColumnModel n : c.getAllLeafColumns()) {
                    cgs.setFieldReference(n);
                    this.dialect.getSqlTypeInfo(n).generatePreparedStatementSet(cgs);
                }
            } else {
                cgs.setFieldReference(c);
                this.dialect.getSqlTypeInfo(c).generatePreparedStatementSet(cgs);
            }
            argIdx[0] = argIdx[0] + 1;
        }
        if (info.hasLimit() && (hasLimitParam || !this.dialect.selectHasLimit())) {
            mv.visitVarInsn(25, psvar);
            if (hasLimitParam) {
                CodeGenSupport cgs2 = new CodeGenSupport(mv){

                    @Override
                    public void pushSqlHandle() {
                        this.mv.visitVarInsn(25, psvar);
                    }

                    @Override
                    public void pushFieldValue() {
                        int n = argIdx[0];
                        this.loadVar(pTypes[n], pVars[n]);
                    }
                };
                cgs2.resetColumnIndex(cgs.getColumnIndex() + 1);
                this.dialect.getSqlTypeInfo(Integer.TYPE).generatePreparedStatementSet(cgs2);
                mv.visitVarInsn(21, pVars[pTypes.length - 1]);
            } else {
                cgs.push(info.getStaticLimit());
            }
            mv.visitMethodInsn(185, Type.getType(PreparedStatement.class).getInternalName(), "setMaxRows", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE));
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, psvar);
        mv.visitMethodInsn(182, this.superTypeName, "queryList", Type.getMethodDescriptor(Type.getType(ResultSet.class), Type.getType(PreparedStatement.class)));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static enum DmlType {
        INSERT("bindOneInsert"),
        UPDATE("bindOneUpdate"),
        DELETE("bindOneDelete");

        final String methodName;

        private DmlType(String m) {
            this.methodName = m;
        }
    }
}

