/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.jdbc.JdbcResultSet;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.AbstractAccess;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmConcurrencyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class JdbcAccess<T, K extends Key<?>>
extends AbstractAccess<T, K> {
    private final JdbcSchema schema;

    protected JdbcAccess(JdbcSchema s) {
        this.schema = s;
    }

    @Override
    public final ResultSet<T> get(Iterable<K> keys) throws OrmException {
        ArrayList<Key> keySet;
        if (keys instanceof Collection) {
            keySet = (ArrayList<Key>)keys;
        } else {
            keySet = new ArrayList<Key>();
            for (Key k : keys) {
                keySet.add(k);
            }
        }
        switch (keySet.size()) {
            case 0: {
                return new ListResultSet(Collections.emptyList());
            }
            case 1: {
                Object entity = this.get((Key)keySet.iterator().next());
                if (entity != null) {
                    return new ListResultSet(Collections.singletonList(entity));
                }
                return new ListResultSet(Collections.emptyList());
            }
        }
        return this.getBySqlIn(keySet);
    }

    protected ResultSet<T> getBySqlIn(Collection<K> keys) throws OrmException {
        return super.get(keys);
    }

    protected PreparedStatement prepareStatement(String sql) throws OrmException {
        try {
            return this.schema.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw this.convertError("prepare SQL\n" + sql + "\n", e);
        }
    }

    protected PreparedStatement prepareBySqlIn(String sql, Collection<K> keys) throws OrmException {
        int n = keys.size();
        StringBuilder buf = new StringBuilder(sql.length() + n << 2);
        buf.append(sql);
        buf.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append('?');
        }
        buf.append(')');
        return this.prepareStatement(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected T queryOne(PreparedStatement ps) throws OrmException {
        try {
            try {
                T t;
                java.sql.ResultSet rs = ps.executeQuery();
                try {
                    T r = null;
                    if (rs.next()) {
                        r = this.newEntityInstance();
                        this.bindOneFetch(rs, r);
                        if (rs.next()) {
                            throw new OrmException("Multiple results");
                        }
                    }
                    t = r;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return t;
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw this.convertError("fetch", e);
        }
    }

    protected ResultSet<T> queryList(PreparedStatement ps) throws OrmException {
        java.sql.ResultSet rs;
        try {
            rs = ps.executeQuery();
            if (!rs.next()) {
                rs.close();
                ps.close();
                return new ListResultSet(Collections.emptyList());
            }
        }
        catch (SQLException err) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw this.convertError("fetch", err);
        }
        return new JdbcResultSet(this, rs, ps);
    }

    @Override
    public void insert(Iterable<T> instances) throws OrmException {
        try {
            if (this.schema.getDialect().canDetermineTotalBatchUpdateCount()) {
                this.insertAsBatch(instances);
            } else {
                this.insertIndividually(instances);
            }
        }
        catch (SQLException e) {
            throw this.convertError("insert", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIndividually(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            boolean concurrencyViolationDetected = false;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getInsertOneSql());
                }
                this.bindOneInsert((PreparedStatement)ps, o);
                int updateCount = ps.executeUpdate();
                if (updateCount == 1) continue;
                concurrencyViolationDetected = true;
            }
            if (concurrencyViolationDetected) {
                throw new OrmConcurrencyException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAsBatch(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            int cnt = 0;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getInsertOneSql());
                }
                this.bindOneInsert((PreparedStatement)ps, o);
                ps.addBatch();
                ++cnt;
            }
            this.execute((PreparedStatement)ps, cnt);
        }
    }

    @Override
    public void update(Iterable<T> instances) throws OrmException {
        try {
            if (this.schema.getDialect().canDetermineTotalBatchUpdateCount()) {
                this.updateAsBatch(instances);
            } else {
                this.updateIndividually(instances);
            }
        }
        catch (SQLException e) {
            throw this.convertError("update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndividually(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            boolean concurrencyViolationDetected = false;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                }
                this.bindOneUpdate((PreparedStatement)ps, o);
                int updateCount = ps.executeUpdate();
                if (updateCount == 1) continue;
                concurrencyViolationDetected = true;
            }
            if (concurrencyViolationDetected) {
                throw new OrmConcurrencyException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAsBatch(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            int cnt = 0;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                }
                this.bindOneUpdate((PreparedStatement)ps, o);
                ps.addBatch();
                ++cnt;
            }
            this.execute((PreparedStatement)ps, cnt);
        }
    }

    private Collection<T> attemptUpdate(Iterable<T> instances) throws OrmException {
        if (this.schema.getDialect().canDetermineIndividualBatchUpdateCounts()) {
            return this.attemptUpdateAsBatch(instances);
        }
        return this.attemptUpdatesIndividually(instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<T> attemptUpdatesIndividually(Iterable<T> instances) throws OrmException {
        ArrayList<T> inserts = null;
        try (Statement ps = null;){
            ArrayList<T> allInstances = new ArrayList<T>();
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                }
                this.bindOneUpdate((PreparedStatement)ps, o);
                int updateCount = ps.executeUpdate();
                if (updateCount != 1) {
                    if (inserts == null) {
                        inserts = new ArrayList<T>();
                    }
                    inserts.add(o);
                }
                allInstances.add(o);
            }
        }
        catch (SQLException e) {
            throw this.convertError("update", e);
        }
        return inserts;
    }

    @Override
    public void upsert(Iterable<T> instances) throws OrmException {
        Collection<T> inserts = this.attemptUpdate(instances);
        if (inserts != null) {
            this.insert(inserts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<T> attemptUpdateAsBatch(Iterable<T> instances) throws OrmException {
        ArrayList<Object> inserts = null;
        try (Statement ps = null;){
            int cnt = 0;
            ArrayList<Object> allInstances = new ArrayList<Object>();
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                }
                this.bindOneUpdate((PreparedStatement)ps, o);
                ps.addBatch();
                allInstances.add(o);
                ++cnt;
            }
            if (0 < cnt) {
                int[] states = ps.executeBatch();
                if (states == null) {
                    inserts = allInstances;
                } else {
                    int i = 0;
                    for (Object e : allInstances) {
                        if (states.length <= i || states[i] != 1) {
                            if (inserts == null) {
                                inserts = new ArrayList(cnt - i);
                            }
                            inserts.add(e);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw this.convertError("update", e);
        }
        return inserts;
    }

    @Override
    public void delete(Iterable<T> instances) throws OrmException {
        try {
            if (this.schema.getDialect().canDetermineTotalBatchUpdateCount()) {
                this.deleteAsBatch(instances);
            } else {
                this.deleteIndividually(instances);
            }
        }
        catch (SQLException e) {
            throw this.convertError("delete", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndividually(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            boolean concurrencyViolationDetected = false;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getDeleteOneSql());
                }
                this.bindOneDelete((PreparedStatement)ps, o);
                int updateCount = ps.executeUpdate();
                if (updateCount == 1) continue;
                concurrencyViolationDetected = true;
            }
            if (concurrencyViolationDetected) {
                throw new OrmConcurrencyException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAsBatch(Iterable<T> instances) throws SQLException, OrmConcurrencyException {
        try (Statement ps = null;){
            int cnt = 0;
            for (T o : instances) {
                if (ps == null) {
                    ps = this.schema.getConnection().prepareStatement(this.getDeleteOneSql());
                }
                this.bindOneDelete((PreparedStatement)ps, o);
                ps.addBatch();
                ++cnt;
            }
            this.execute((PreparedStatement)ps, cnt);
        }
    }

    private void execute(PreparedStatement ps, int cnt) throws SQLException, OrmConcurrencyException {
        if (cnt == 0) {
            return;
        }
        int numberOfRowsUpdated = this.schema.getDialect().executeBatch(ps);
        if (numberOfRowsUpdated != cnt) {
            throw new OrmConcurrencyException();
        }
    }

    protected OrmException convertError(String op, SQLException err) {
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return this.schema.getDialect().convertError(op, this.getRelationName(), err);
    }

    protected abstract T newEntityInstance();

    protected abstract String getInsertOneSql();

    protected abstract String getUpdateOneSql();

    protected abstract String getDeleteOneSql();

    protected abstract void bindOneInsert(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneUpdate(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneDelete(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneFetch(java.sql.ResultSet var1, T var2) throws SQLException;
}

