/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.internal.guava.collect.$Iterators;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.InstanceServletBindingImpl;
import com.google.inject.servlet.LinkedServletBindingImpl;
import com.google.inject.servlet.ServletModuleTargetVisitor;
import com.google.inject.servlet.ServletUtils;
import com.google.inject.servlet.UriPatternMatcher;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletDefinition
implements ProviderWithExtensionVisitor<ServletDefinition> {
    private final String pattern;
    private final Key<? extends HttpServlet> servletKey;
    private final UriPatternMatcher patternMatcher;
    private final Map<String, String> initParams;
    private final HttpServlet servletInstance;
    private final AtomicReference<HttpServlet> httpServlet = new AtomicReference();

    public ServletDefinition(String pattern, Key<? extends HttpServlet> servletKey, UriPatternMatcher patternMatcher, Map<String, String> initParams, HttpServlet servletInstance) {
        this.pattern = pattern;
        this.servletKey = servletKey;
        this.patternMatcher = patternMatcher;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(initParams));
        this.servletInstance = servletInstance;
    }

    @Override
    public ServletDefinition get() {
        return this;
    }

    @Override
    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        if (visitor instanceof ServletModuleTargetVisitor) {
            if (this.servletInstance != null) {
                return ((ServletModuleTargetVisitor)visitor).visit(new InstanceServletBindingImpl(this.initParams, this.pattern, this.servletInstance, this.patternMatcher));
            }
            return ((ServletModuleTargetVisitor)visitor).visit(new LinkedServletBindingImpl(this.initParams, this.pattern, this.servletKey, this.patternMatcher));
        }
        return visitor.visit(binding);
    }

    boolean shouldServe(String uri) {
        return uri != null && this.patternMatcher.matches(uri);
    }

    public void init(final ServletContext servletContext, Injector injector, Set<HttpServlet> initializedSoFar) throws ServletException {
        if (!Scopes.isSingleton(injector.getBinding(this.servletKey))) {
            throw new ServletException("Servlets must be bound as singletons. " + this.servletKey + " was not bound in singleton scope.");
        }
        HttpServlet httpServlet = injector.getInstance(this.servletKey);
        this.httpServlet.set(httpServlet);
        if (initializedSoFar.contains(httpServlet)) {
            return;
        }
        httpServlet.init(new ServletConfig(){

            public String getServletName() {
                return ServletDefinition.this.servletKey.toString();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return (String)ServletDefinition.this.initParams.get(s);
            }

            public Enumeration getInitParameterNames() {
                return $Iterators.asEnumeration(ServletDefinition.this.initParams.keySet().iterator());
            }
        });
        initializedSoFar.add(httpServlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Set<HttpServlet> destroyedSoFar) {
        HttpServlet reference = this.httpServlet.get();
        if (null == reference || destroyedSoFar.contains(reference)) {
            return;
        }
        try {
            reference.destroy();
        }
        finally {
            destroyedSoFar.add(reference);
        }
    }

    public boolean service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String path = ServletUtils.getContextRelativePath(request);
        boolean serve = this.shouldServe(path);
        if (serve) {
            this.doService(servletRequest, servletResponse);
        }
        return serve;
    }

    void doService(final ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequestWrapper request = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){
            private boolean pathComputed;
            private String path;
            private boolean pathInfoComputed;
            private String pathInfo;

            public String getPathInfo() {
                if (!this.isPathInfoComputed()) {
                    int servletPathLength = this.getServletPath().length();
                    this.pathInfo = this.getRequestURI().substring(this.getContextPath().length()).replaceAll("[/]{2,}", "/");
                    String string = this.pathInfo = this.pathInfo.length() > servletPathLength ? this.pathInfo.substring(servletPathLength) : null;
                    if ("".equals(this.pathInfo) && servletPathLength != 0) {
                        this.pathInfo = null;
                    }
                    this.pathInfoComputed = true;
                }
                return this.pathInfo;
            }

            private boolean isPathInfoComputed() {
                return this.pathInfoComputed && null == servletRequest.getAttribute("javax.servlet.forward.servlet_path");
            }

            private boolean isPathComputed() {
                return this.pathComputed && null == servletRequest.getAttribute("javax.servlet.forward.servlet_path");
            }

            public String getServletPath() {
                return this.computePath();
            }

            public String getPathTranslated() {
                String info = this.getPathInfo();
                return null == info ? null : this.getRealPath(info);
            }

            private String computePath() {
                if (!this.isPathComputed()) {
                    String servletPath = super.getServletPath();
                    this.path = ServletDefinition.this.patternMatcher.extractPath(servletPath);
                    this.pathComputed = true;
                    if (null == this.path) {
                        this.path = servletPath;
                    }
                }
                return this.path;
            }
        };
        this.doServiceImpl(request, (HttpServletResponse)servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServiceImpl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GuiceFilter.Context previous = GuiceFilter.localContext.get();
        HttpServletRequest originalRequest = previous != null ? previous.getOriginalRequest() : request;
        GuiceFilter.localContext.set(new GuiceFilter.Context(originalRequest, request, response));
        try {
            this.httpServlet.get().service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            GuiceFilter.localContext.set(previous);
        }
    }

    String getKey() {
        return this.servletKey.toString();
    }

    String getPattern() {
        return this.pattern;
    }
}

