/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.Text;
import com.googlecode.prolog_cafe.lang.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.JavaException;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class PRED_commit_edits_2
extends Predicate.P2 {
    public PRED_commit_edits_2(Term a1, Term a2, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        engine.setB0();
        Term a1 = this.arg1.dereference();
        Term a2 = this.arg2.dereference();
        Pattern fileRegex = this.getRegexParameter(a1);
        Pattern editRegex = this.getRegexParameter(a2);
        PatchList pl = StoredValues.PATCH_LIST.get(engine);
        Repository repo = StoredValues.REPOSITORY.get(engine);
        ObjectReader reader = repo.newObjectReader();
        try {
            RevWalk rw = new RevWalk(reader);
            RevCommit bCommit = rw.parseCommit(pl.getNewId());
            if (pl.getOldId() == null) {
                Operation operation = engine.fail();
                return operation;
            }
            RevTree aTree = rw.parseTree(pl.getOldId());
            RevTree bTree = bCommit.getTree();
            for (PatchListEntry entry : pl.getPatches()) {
                List<Edit> edits;
                String newName = entry.getNewName();
                String oldName = entry.getOldName();
                if (newName.equals("/COMMIT_MSG") || !fileRegex.matcher(newName).find() && (oldName == null || !fileRegex.matcher(oldName).find()) || (edits = entry.getEdits()).isEmpty()) continue;
                Text tA = oldName != null ? this.load(aTree, oldName, reader) : this.load(aTree, newName, reader);
                Text tB = this.load(bTree, newName, reader);
                for (Edit edit : edits) {
                    String bDiff;
                    String aDiff;
                    if (tA != Text.EMPTY && editRegex.matcher(aDiff = tA.getString(edit.getBeginA(), edit.getEndA(), true)).find()) {
                        Operation operation = this.cont;
                        return operation;
                    }
                    if (tB == Text.EMPTY || !editRegex.matcher(bDiff = tB.getString(edit.getBeginB(), edit.getEndB(), true)).find()) continue;
                    Operation operation = this.cont;
                    return operation;
                }
            }
        }
        catch (IOException err) {
            throw new JavaException(this, 1, err);
        }
        finally {
            reader.release();
        }
        return engine.fail();
    }

    private Pattern getRegexParameter(Term term) {
        if (term.isVariable()) {
            throw new PInstantiationException(this, 1);
        }
        if (!term.isSymbol()) {
            throw new IllegalTypeException(this, 1, "symbol", term);
        }
        return Pattern.compile(term.name(), 8);
    }

    private Text load(ObjectId tree, String path, ObjectReader reader) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        if (path == null) {
            return Text.EMPTY;
        }
        TreeWalk tw = TreeWalk.forPath(reader, path, tree);
        if (tw == null) {
            return Text.EMPTY;
        }
        if (tw.getFileMode(0).getObjectType() != 3) {
            return Text.EMPTY;
        }
        return new Text(reader.open(tw.getObjectId(0), 3));
    }
}

