/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentForwardedChannel;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentServerProxy
implements SshAgentServer {
    private static final Logger LOG = LoggerFactory.getLogger(AgentServerProxy.class);
    private final ConnectionService service;
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;
    private boolean closed;

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = service;
        try {
            String authSocket = AprLibrary.createLocalSocketAddress();
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            int result = Local.bind((long)this.handle, (long)0L);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            AprLibrary.secureLocalSocket(authSocket, this.handle);
            result = Local.listen((long)this.handle, (int)0);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            this.thread = new Thread(){

                public void run() {
                    while (!AgentServerProxy.this.closed) {
                        try {
                            long clientSock = Local.accept((long)AgentServerProxy.this.handle);
                            if (!AgentServerProxy.this.closed) {
                                Socket.timeoutSet((long)clientSock, (long)10000000L);
                                AgentForwardedChannel channel = new AgentForwardedChannel(clientSock);
                                AgentServerProxy.this.service.registerChannel(channel);
                                OpenFuture future = (OpenFuture)channel.open().await();
                                Throwable t = future.getException();
                                if (t instanceof Exception) {
                                    throw (Exception)t;
                                }
                                if (t == null) continue;
                                throw new Exception(t);
                            }
                            break;
                        }
                        catch (Exception e) {
                            if (AgentServerProxy.this.closed) continue;
                            LOG.info("Exchange caught in authentication forwarding", e);
                        }
                    }
                }
            };
            this.thread.start();
            this.authSocket = authSocket;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    public String getId() {
        return this.authSocket;
    }

    public synchronized void close() {
        this.closed = true;
        if (this.handle != 0L) {
            Socket.close((long)this.handle);
        }
    }

    static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

