/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.deprecated;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Iterator;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.deprecated.AbstractUserAuth;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.util.Buffer;

public class UserAuthAgent
extends AbstractUserAuth {
    private final SshAgent agent;
    private final Iterator<SshAgent.Pair<PublicKey, String>> keys;

    public UserAuthAgent(ClientSessionImpl session, String service) throws IOException {
        super(session, service);
        if (session.getFactoryManager().getAgentFactory() == null) {
            throw new IllegalStateException("No ssh agent factory has been configured");
        }
        this.agent = session.getFactoryManager().getAgentFactory().createClient(session.getFactoryManager());
        this.keys = this.agent.getIdentities().iterator();
    }

    protected void sendNextKey(PublicKey key) throws IOException {
        try {
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for publickey");
            Buffer buffer = this.session.createBuffer((byte)50);
            int pos1 = buffer.wpos() - 1;
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("publickey");
            buffer.putByte((byte)1);
            buffer.putString(key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            int pos2 = buffer.wpos();
            buffer.putPublicKey(key);
            Buffer bs = new Buffer();
            bs.putString(this.session.getKex().getH());
            bs.putByte((byte)50);
            bs.putString(this.session.getUsername());
            bs.putString(this.service);
            bs.putString("publickey");
            bs.putByte((byte)1);
            bs.putString(key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            bs.putPublicKey(key);
            Buffer bs2 = new Buffer();
            bs2.putString(key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            bs2.putBytes(this.agent.sign(key, bs.getCompactData()));
            buffer.putBytes(bs2.array(), bs2.rpos(), bs2.available());
            this.session.writePacket(buffer);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error performing public key authentication").initCause(e);
        }
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            if (this.keys.hasNext()) {
                this.sendNextKey(this.keys.next().getFirst());
                return UserAuth.Result.Continued;
            }
            this.agent.close();
            return UserAuth.Result.Failure;
        }
        byte cmd = buffer.getByte();
        if (cmd == 52) {
            this.log.info("Received SSH_MSG_USERAUTH_SUCCESS");
            this.agent.close();
            return UserAuth.Result.Success;
        }
        if (cmd == 51) {
            this.log.info("Received SSH_MSG_USERAUTH_FAILURE");
            if (this.keys.hasNext()) {
                this.sendNextKey(this.keys.next().getFirst());
                return UserAuth.Result.Continued;
            }
            this.agent.close();
            return UserAuth.Result.Failure;
        }
        this.log.info("Received unknown packet: {}", cmd);
        return UserAuth.Result.Continued;
    }
}

