/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableUtils {
    public static CloseFuture closed() {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        future.setClosed();
        return future;
    }

    public static Closeable parallel(Collection<? extends Closeable> closeables) {
        return CloseableUtils.parallel(null, closeables);
    }

    public static Closeable parallel(Object lock, Collection<? extends Closeable> closeables) {
        return CloseableUtils.parallel(lock, closeables.toArray(new Closeable[closeables.size()]));
    }

    public static Closeable parallel(Closeable ... closeables) {
        return CloseableUtils.parallel(null, closeables);
    }

    public static Closeable parallel(final Object lock, final Closeable ... closeables) {
        if (closeables.length == 0) {
            return new Closeable(){

                public CloseFuture close(boolean immediately) {
                    DefaultCloseFuture future = new DefaultCloseFuture(lock);
                    future.setClosed();
                    return future;
                }
            };
        }
        if (closeables.length == 1) {
            return closeables[0];
        }
        return new Closeable(){

            public CloseFuture close(boolean immediately) {
                final DefaultCloseFuture future = new DefaultCloseFuture(lock);
                final AtomicInteger count = new AtomicInteger(closeables.length);
                SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture f) {
                        if (count.decrementAndGet() == 0) {
                            future.setClosed();
                        }
                    }
                };
                for (Closeable c : closeables) {
                    c.close(immediately).addListener(listener);
                }
                return future;
            }
        };
    }

    public static Closeable sequential(Collection<? extends Closeable> closeables) {
        return CloseableUtils.sequential(null, closeables);
    }

    public static Closeable sequential(Object lock, Collection<? extends Closeable> closeables) {
        return CloseableUtils.sequential(lock, closeables.toArray(new Closeable[closeables.size()]));
    }

    public static Closeable sequential(Closeable ... closeables) {
        return CloseableUtils.sequential(null, closeables);
    }

    public static Closeable sequential(final Object lock, final Closeable ... closeables) {
        if (closeables.length == 0) {
            return new Closeable(){

                public CloseFuture close(boolean immediately) {
                    DefaultCloseFuture future = new DefaultCloseFuture(lock);
                    future.setClosed();
                    return future;
                }
            };
        }
        if (closeables.length == 1) {
            return closeables[0];
        }
        return new Closeable(){

            public CloseFuture close(final boolean immediately) {
                final DefaultCloseFuture future = new DefaultCloseFuture(lock);
                final Iterator<Closeable> iterator = Arrays.asList(closeables).iterator();
                SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture previousFuture) {
                        if (iterator.hasNext()) {
                            Closeable c = (Closeable)iterator.next();
                            CloseFuture nextFuture = c.close(immediately);
                            nextFuture.addListener(this);
                        } else {
                            future.setClosed();
                        }
                    }
                };
                listener.operationComplete(null);
                return future;
            }
        };
    }

    public static SshFuture parallel(SshFuture ... futures) {
        if (futures.length == 0) {
            DefaultSshFuture future = new DefaultSshFuture(null);
            future.setValue(true);
            return future;
        }
        if (futures.length == 1) {
            return futures[0];
        }
        final DefaultCloseFuture future = new DefaultCloseFuture(null);
        final AtomicInteger count = new AtomicInteger(futures.length);
        SshFutureListener<SshFuture> listener = new SshFutureListener<SshFuture>(){

            @Override
            public void operationComplete(SshFuture f) {
                if (count.decrementAndGet() == 0) {
                    future.setClosed();
                }
            }
        };
        for (SshFuture f : futures) {
            f.addListener(listener);
        }
        return future;
    }

    private CloseableUtils() {
    }

    public static abstract class AbstractInnerCloseable
    extends AbstractCloseable {
        protected abstract Closeable getInnerCloseable();

        protected SshFuture doCloseGracefully() {
            return this.getInnerCloseable().close(false);
        }

        protected void doCloseImmediately() {
            this.getInnerCloseable().close(true).addListener(new SshFutureListener<CloseFuture>(){

                @Override
                public void operationComplete(CloseFuture future) {
                    AbstractInnerCloseable.this.postClose();
                }
            });
        }
    }

    public static abstract class AbstractCloseable
    implements Closeable {
        protected static final int OPENED = 0;
        protected static final int GRACEFUL = 1;
        protected static final int IMMEDIATE = 2;
        protected static final int CLOSED = 3;
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        protected final Object lock = new Object();
        protected final AtomicInteger state = new AtomicInteger();
        protected final CloseFuture closeFuture = new DefaultCloseFuture(this.lock);

        public CloseFuture close(boolean immediately) {
            if (immediately) {
                if (this.state.compareAndSet(0, 2) || this.state.compareAndSet(1, 2)) {
                    this.log.debug("Closing {} immediately", this);
                    this.doCloseImmediately();
                } else {
                    this.log.debug("{} is already {}", this, (Object)(this.state.get() == 3 ? "closed" : "closing"));
                }
            } else if (this.state.compareAndSet(0, 1)) {
                this.log.debug("Closing {} gracefully", this);
                SshFuture grace = this.doCloseGracefully();
                if (grace != null) {
                    grace.addListener(new SshFutureListener(){

                        public void operationComplete(SshFuture future) {
                            if (AbstractCloseable.this.state.compareAndSet(1, 2)) {
                                AbstractCloseable.this.doCloseImmediately();
                            }
                        }
                    });
                } else if (this.state.compareAndSet(1, 2)) {
                    this.doCloseImmediately();
                }
            } else {
                this.log.debug("{} is already {}", this, (Object)(this.state.get() == 3 ? "closed" : "closing"));
            }
            return this.closeFuture;
        }

        protected SshFuture doCloseGracefully() {
            return null;
        }

        protected void doCloseImmediately() {
            this.postClose();
        }

        protected void postClose() {
            this.closeFuture.setClosed();
            this.state.set(3);
            this.log.debug("{} closed", this);
        }
    }
}

