/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X11ForwardSupport
implements IoHandler,
Closeable {
    private static String xauthCommand = System.getProperty("sshd.xauthCommand", "xauth");
    public static final int X11_DISPLAY_OFFSET = 10;
    public static final int MAX_DISPLAYS = 1000;
    public static final String ENV_DISPLAY = "DISPLAY";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public X11ForwardSupport(ConnectionService service) {
        this.service = service;
    }

    public synchronized void initialize() {
        if (this.acceptor == null) {
            this.acceptor = this.service.getSession().getFactoryManager().getIoServiceFactory().createAcceptor(this);
        }
    }

    public synchronized void close() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
            this.acceptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseFuture close(boolean immediately) {
        IoAcceptor a;
        X11ForwardSupport x11ForwardSupport = this;
        synchronized (x11ForwardSupport) {
            a = this.acceptor;
            this.acceptor = null;
        }
        if (a != null) {
            return a.close(immediately);
        }
        return CloseableUtils.closed();
    }

    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        int displayNumber;
        this.initialize();
        InetSocketAddress addr = null;
        for (displayNumber = 10; displayNumber < 1000; ++displayNumber) {
            int port = 6000 + displayNumber;
            try {
                addr = new InetSocketAddress("127.0.0.1", port);
                this.acceptor.bind(addr);
                break;
            }
            catch (BindException bindErr) {
                continue;
            }
        }
        if (displayNumber >= 1000) {
            this.log.error("Failed to allocate internet-domain X11 display socket.");
            if (this.acceptor.getBoundAddresses().isEmpty()) {
                this.close();
            }
            return null;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") < 0) {
            try {
                String authDisplay = "unix:" + displayNumber + "." + screen;
                Process p = new ProcessBuilder(xauthCommand, "remove", authDisplay).start();
                int result = p.waitFor();
                if (result == 0) {
                    p = new ProcessBuilder(xauthCommand, "add", authDisplay, authenticationProtocol, authenticationCookie).start();
                    result = p.waitFor();
                }
            }
            catch (Exception e) {
                this.log.error("Could not run xauth", e);
                return null;
            }
            return "localhost:" + displayNumber + "." + screen;
        }
        return null;
    }

    public void sessionCreated(IoSession session) throws Exception {
        ChannelForwardedX11 channel = new ChannelForwardedX11(session);
        session.setAttribute(ChannelForwardedX11.class, channel);
        this.service.registerChannel(channel);
        OpenFuture future = (OpenFuture)channel.open().await();
        Throwable t = future.getException();
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t != null) {
            throw new Exception(t);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        if (channel != null) {
            channel.close(false);
        }
    }

    public void messageReceived(IoSession session, Readable message) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        Buffer buffer = new Buffer();
        buffer.putBuffer(message);
        channel.getOut().write(buffer.array(), buffer.rpos(), buffer.available());
        channel.getOut().flush();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    public static class ChannelForwardedX11
    extends AbstractClientChannel {
        private final IoSession serverSession;

        public ChannelForwardedX11(IoSession serverSession) {
            super("x11");
            this.serverSession = serverSession;
        }

        public synchronized OpenFuture open() throws IOException {
            InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
            if (this.closeFuture.isClosed()) {
                throw new SshException("Session has been closed");
            }
            this.openFuture = new DefaultOpenFuture(this.lock);
            this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", this.id);
            Buffer buffer = this.session.createBuffer((byte)90);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.localWindow.getSize());
            buffer.putInt(this.localWindow.getPacketSize());
            buffer.putString(remote.getAddress().getHostAddress());
            buffer.putInt(remote.getPort());
            this.writePacket(buffer);
            return this.openFuture;
        }

        protected synchronized void doOpen() throws IOException {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
        }

        protected Closeable getInnerCloseable() {
            return CloseableUtils.sequential(this.serverSession, super.getInnerCloseable());
        }

        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            this.localWindow.consumeAndCheck(len);
            this.serverSession.write(new Buffer(data, off, len));
        }

        public void handleEof() throws IOException {
            super.handleEof();
            this.serverSession.close(false);
        }
    }
}

